/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import info.ata4.io.lzma.LzmaEncoderProps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;
import lzma.LzmaEncoder;
import net.contrapunctus.lzma.ConcurrentBufferInputStream;
import net.contrapunctus.lzma.ConcurrentBufferOutputStream;

class EncoderThread
extends Thread {
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;
    protected ArrayBlockingQueue<byte[]> q = ConcurrentBufferOutputStream.newQueue();
    protected InputStream in = ConcurrentBufferInputStream.create(this.q);
    protected OutputStream out;
    protected LzmaEncoder enc;
    protected LzmaEncoderProps props;
    protected IOException exn;

    EncoderThread(OutputStream _out, LzmaEncoderProps _props) {
        this.out = _out;
        this.enc = new LzmaEncoder();
        this.exn = null;
        this.props = _props;
        if (DEBUG) {
            dbg.printf("%s << %s (%s)%n", this, this.in, this.q);
        }
    }

    public void run() {
        block4: {
            try {
                this.props.apply(this.enc);
                this.props.toOutputStream(this.out);
                if (DEBUG) {
                    dbg.printf("%s begins%n", this);
                }
                this.enc.code(this.in, this.out);
                if (DEBUG) {
                    dbg.printf("%s ends%n", this);
                }
                this.out.close();
            }
            catch (IOException _exn) {
                this.exn = _exn;
                if (!DEBUG) break block4;
                dbg.printf("%s exception: %s%n", this.exn.getMessage());
            }
        }
    }

    public LzmaEncoderProps getProps() {
        return this.props;
    }

    public String toString() {
        return String.format("Enc@%x", this.hashCode());
    }

    static {
        String ds = null;
        try {
            ds = System.getProperty("DEBUG_LzmaCoders");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = ds != null;
    }
}

