/*
 * Decompiled with CFR 0.152.
 */
package lzma;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.Decoder2;
import lzma.LenDecoder;
import lzma.LiteralDecoder;
import lzma.LzmaState;
import lzma.lz.OutWindow;
import lzma.rangecoder.BitTreeDecoder;
import lzma.rangecoder.RangeDecoder;

public class LzmaDecoder {
    private OutWindow m_OutWindow = new OutWindow();
    private RangeDecoder m_RangeDecoder = new RangeDecoder();
    private short[] m_IsMatchDecoders = new short[192];
    private short[] m_IsRepDecoders = new short[12];
    private short[] m_IsRepG0Decoders = new short[12];
    private short[] m_IsRepG1Decoders = new short[12];
    private short[] m_IsRepG2Decoders = new short[12];
    private short[] m_IsRep0LongDecoders = new short[192];
    private BitTreeDecoder[] m_PosSlotDecoder = new BitTreeDecoder[4];
    private short[] m_PosDecoders = new short[114];
    private BitTreeDecoder m_PosAlignDecoder = new BitTreeDecoder(4);
    private LenDecoder m_LenDecoder = new LenDecoder();
    private LenDecoder m_RepLenDecoder = new LenDecoder();
    private LiteralDecoder m_LiteralDecoder = new LiteralDecoder();
    private int m_DictionarySize = -1;
    private int m_DictionarySizeCheck = -1;
    private int m_PosStateMask;

    public LzmaDecoder() {
        for (int i = 0; i < 4; ++i) {
            this.m_PosSlotDecoder[i] = new BitTreeDecoder(6);
        }
    }

    public boolean setDictionarySize(int dictionarySize) {
        if (dictionarySize < 0) {
            return false;
        }
        if (this.m_DictionarySize != dictionarySize) {
            this.m_DictionarySize = dictionarySize;
            this.m_DictionarySizeCheck = Math.max(this.m_DictionarySize, 1);
            this.m_OutWindow.create(Math.max(this.m_DictionarySizeCheck, 4096));
        }
        return true;
    }

    public boolean setLcLpPb(int lc, int lp, int pb) {
        if (lc > 8 || lp > 4 || pb > 4) {
            return false;
        }
        this.m_LiteralDecoder.create(lp, lc);
        int numPosStates = 1 << pb;
        this.m_LenDecoder.create(numPosStates);
        this.m_RepLenDecoder.create(numPosStates);
        this.m_PosStateMask = numPosStates - 1;
        return true;
    }

    private void init() throws IOException {
        this.m_OutWindow.init(false);
        RangeDecoder.initBitModels(this.m_IsMatchDecoders);
        RangeDecoder.initBitModels(this.m_IsRep0LongDecoders);
        RangeDecoder.initBitModels(this.m_IsRepDecoders);
        RangeDecoder.initBitModels(this.m_IsRepG0Decoders);
        RangeDecoder.initBitModels(this.m_IsRepG1Decoders);
        RangeDecoder.initBitModels(this.m_IsRepG2Decoders);
        RangeDecoder.initBitModels(this.m_PosDecoders);
        this.m_LiteralDecoder.init();
        for (int i = 0; i < 4; ++i) {
            this.m_PosSlotDecoder[i].init();
        }
        this.m_LenDecoder.init();
        this.m_RepLenDecoder.init();
        this.m_PosAlignDecoder.init();
        this.m_RangeDecoder.init();
    }

    public boolean code(InputStream inStream, OutputStream outStream, long outSize) throws IOException {
        this.m_RangeDecoder.setStream(inStream);
        this.m_OutWindow.setStream(outStream);
        this.init();
        int state = LzmaState.stateInit();
        int rep0 = 0;
        int rep1 = 0;
        int rep2 = 0;
        int rep3 = 0;
        long nowPos64 = 0L;
        byte prevByte = 0;
        while (outSize < 0L || nowPos64 < outSize) {
            int len;
            int posState = (int)nowPos64 & this.m_PosStateMask;
            if (this.m_RangeDecoder.decodeBit(this.m_IsMatchDecoders, (state << 4) + posState) == 0) {
                Decoder2 decoder2 = this.m_LiteralDecoder.getDecoder((int)nowPos64, prevByte);
                prevByte = !LzmaState.stateIsCharState(state) ? decoder2.decodeWithMatchByte(this.m_RangeDecoder, this.m_OutWindow.getByte(rep0)) : decoder2.decodeNormal(this.m_RangeDecoder);
                this.m_OutWindow.putByte(prevByte);
                state = LzmaState.stateUpdateChar(state);
                ++nowPos64;
                continue;
            }
            if (this.m_RangeDecoder.decodeBit(this.m_IsRepDecoders, state) == 1) {
                len = 0;
                if (this.m_RangeDecoder.decodeBit(this.m_IsRepG0Decoders, state) == 0) {
                    if (this.m_RangeDecoder.decodeBit(this.m_IsRep0LongDecoders, (state << 4) + posState) == 0) {
                        state = LzmaState.stateUpdateShortRep(state);
                        len = 1;
                    }
                } else {
                    int distance;
                    if (this.m_RangeDecoder.decodeBit(this.m_IsRepG1Decoders, state) == 0) {
                        distance = rep1;
                    } else {
                        if (this.m_RangeDecoder.decodeBit(this.m_IsRepG2Decoders, state) == 0) {
                            distance = rep2;
                        } else {
                            distance = rep3;
                            rep3 = rep2;
                        }
                        rep2 = rep1;
                    }
                    rep1 = rep0;
                    rep0 = distance;
                }
                if (len == 0) {
                    len = this.m_RepLenDecoder.decode(this.m_RangeDecoder, posState) + 2;
                    state = LzmaState.stateUpdateRep(state);
                }
            } else {
                rep3 = rep2;
                rep2 = rep1;
                rep1 = rep0;
                len = 2 + this.m_LenDecoder.decode(this.m_RangeDecoder, posState);
                state = LzmaState.stateUpdateMatch(state);
                int posSlot = this.m_PosSlotDecoder[LzmaState.getLenToPosState(len)].decode(this.m_RangeDecoder);
                if (posSlot >= 4) {
                    int numDirectBits = (posSlot >> 1) - 1;
                    rep0 = (2 | posSlot & 1) << numDirectBits;
                    if (posSlot < 14) {
                        rep0 += BitTreeDecoder.reverseDecode(this.m_PosDecoders, rep0 - posSlot - 1, this.m_RangeDecoder, numDirectBits);
                    } else {
                        rep0 += this.m_RangeDecoder.decodeDirectBits(numDirectBits - 4) << 4;
                        if ((rep0 += this.m_PosAlignDecoder.reverseDecode(this.m_RangeDecoder)) < 0) {
                            if (rep0 == -1) break;
                            return false;
                        }
                    }
                } else {
                    rep0 = posSlot;
                }
            }
            if ((long)rep0 >= nowPos64 || rep0 >= this.m_DictionarySizeCheck) {
                return false;
            }
            this.m_OutWindow.copyBlock(rep0, len);
            nowPos64 += (long)len;
            prevByte = this.m_OutWindow.getByte(0);
        }
        this.m_OutWindow.flush();
        this.m_OutWindow.releaseStream();
        this.m_RangeDecoder.releaseStream();
        return true;
    }
}

