/*
 * Decompiled with CFR 0.152.
 */
package lzma;

import java.io.IOException;
import lzma.LenEncoder;
import lzma.rangecoder.RangeEncoder;

class LenPriceTableEncoder
extends LenEncoder {
    int[] _prices = new int[4352];
    int _tableSize;
    int[] _counters = new int[16];

    LenPriceTableEncoder() {
    }

    void setTableSize(int tableSize) {
        this._tableSize = tableSize;
    }

    int getPrice(int symbol, int posState) {
        return this._prices[posState * 272 + symbol];
    }

    void updateTable(int posState) {
        this.setPrices(posState, this._tableSize, this._prices, posState * 272);
        this._counters[posState] = this._tableSize;
    }

    void updateTables(int numPosStates) {
        for (int posState = 0; posState < numPosStates; ++posState) {
            this.updateTable(posState);
        }
    }

    void encode(RangeEncoder rangeEncoder, int symbol, int posState) throws IOException {
        super.encode(rangeEncoder, symbol, posState);
        int n = posState;
        this._counters[n] = this._counters[n] - 1;
        if (this._counters[n] == 0) {
            this.updateTable(posState);
        }
    }
}

