/*
 * Decompiled with CFR 0.152.
 */
package lzma;

import java.io.IOException;
import lzma.rangecoder.BitTreeDecoder;
import lzma.rangecoder.RangeDecoder;

class LenDecoder {
    private short[] m_Choice = new short[2];
    private BitTreeDecoder[] m_LowCoder = new BitTreeDecoder[16];
    private BitTreeDecoder[] m_MidCoder = new BitTreeDecoder[16];
    private BitTreeDecoder m_HighCoder = new BitTreeDecoder(8);
    private int m_NumPosStates = 0;

    LenDecoder() {
    }

    void create(int numPosStates) {
        while (this.m_NumPosStates < numPosStates) {
            this.m_LowCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
            this.m_MidCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
            ++this.m_NumPosStates;
        }
    }

    void init() {
        RangeDecoder.initBitModels(this.m_Choice);
        for (int posState = 0; posState < this.m_NumPosStates; ++posState) {
            this.m_LowCoder[posState].init();
            this.m_MidCoder[posState].init();
        }
        this.m_HighCoder.init();
    }

    int decode(RangeDecoder rangeDecoder, int posState) throws IOException {
        if (rangeDecoder.decodeBit(this.m_Choice, 0) == 0) {
            return this.m_LowCoder[posState].decode(rangeDecoder);
        }
        int symbol = 8;
        symbol = rangeDecoder.decodeBit(this.m_Choice, 1) == 0 ? (symbol += this.m_MidCoder[posState].decode(rangeDecoder)) : (symbol += 8 + this.m_HighCoder.decode(rangeDecoder));
        return symbol;
    }
}

