/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.util.gui;

import info.ata4.util.gui.RowTableModel;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListTableModel
extends RowTableModel<List> {
    protected static List<String> newList(int size) {
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
        return list;
    }

    public ListTableModel(int columns) {
        super(ListTableModel.newList(columns));
        this.setRowClass(List.class);
    }

    public ListTableModel(List<String> columnNames) {
        super(columnNames);
        this.setRowClass(List.class);
    }

    public ListTableModel(int rows, int columns) {
        super(ListTableModel.newList(columns));
        this.setRowClass(List.class);
        ArrayList<List> data = new ArrayList<List>(rows);
        for (int i = 0; i < rows; ++i) {
            data.add(new ArrayList(columns));
        }
        this.insertRows(0, (List<List>)data);
    }

    public ListTableModel(List<List> modelData, List<String> columnNames) {
        super(modelData, columnNames);
        this.setRowClass(List.class);
    }

    @Override
    public Object getValueAt(int row, int column) {
        List rowData = (List)this.getRow(row);
        return rowData.get(column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        List rowData = (List)this.getRow(row);
        rowData.set(column, value);
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public void insertRow(int row, List rowData) {
        this.justifyRow(rowData);
        super.insertRow(row, rowData);
    }

    @Override
    public void insertRows(int row, List<List> rowList) {
        for (List rowData : rowList) {
            this.justifyRow(rowData);
        }
        super.insertRows(row, rowList);
    }

    private void justifyRow(List rowData) {
        for (int i = rowData.size(); i < this.getColumnCount(); ++i) {
            rowData.add(null);
        }
    }

    @Override
    public void addRow(Object[] rowData) {
        this.insertRow(this.getRowCount(), rowData);
    }

    @Override
    public void insertRow(int row, Object[] rowData) {
        this.insertRow(row, this.copyToList(rowData));
    }

    public void insertRows(int row, Object[][] rowArray) {
        ArrayList<List> data = new ArrayList<List>(rowArray.length);
        for (int i = 0; i < rowArray.length; ++i) {
            data.add(this.copyToList(rowArray[i]));
        }
        this.insertRows(row, (List<List>)data);
    }

    private List copyToList(Object[] rowData) {
        ArrayList<Object> row = new ArrayList<Object>(rowData.length);
        row.addAll(Arrays.asList(rowData));
        return row;
    }

    public static ListTableModel createModelFromResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columns = metaData.getColumnCount();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 1; i <= columns; ++i) {
            String columnName = metaData.getColumnName(i);
            String columnLabel = metaData.getColumnLabel(i);
            if (columnLabel.equals(columnName)) {
                columnNames.add(ListTableModel.formatColumnName(columnName));
                continue;
            }
            columnNames.add(columnLabel);
        }
        ListTableModel model = new ListTableModel(columnNames);
        model.setModelEditable(false);
        for (int i = 1; i <= columns; ++i) {
            try {
                String className = metaData.getColumnClassName(i);
                model.setColumnClass(i - 1, Class.forName(className));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<List> data = new ArrayList<List>();
        while (resultSet.next()) {
            ArrayList<Object> row = new ArrayList<Object>(columns);
            for (int i = 1; i <= columns; ++i) {
                Object o = resultSet.getObject(i);
                row.add(o);
            }
            data.add(row);
        }
        model.insertRows(0, (List<List>)data);
        return model;
    }
}

