/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.buffer.source;

import info.ata4.io.buffer.source.ChannelSource;
import info.ata4.io.buffer.source.NonReadableSourceException;
import info.ata4.io.buffer.source.NonWritableSourceException;
import info.ata4.io.buffer.source.ReadableByteChannelSource;
import info.ata4.io.buffer.source.WritableByteChannelSource;
import info.ata4.io.channel.ChannelUtils;
import info.ata4.log.LogUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SeekableByteChannelSource
extends ChannelSource<SeekableByteChannel> {
    private static final Logger L = LogUtils.getLogger();
    private final ReadableByteChannelSource bufIn;
    private final WritableByteChannelSource bufOut;
    private boolean write;

    public SeekableByteChannelSource(ByteBuffer buffer, SeekableByteChannel chan) {
        super(buffer, chan);
        this.bufIn = ChannelUtils.isReadable(chan) ? new ReadableByteChannelSource(buffer, chan) : null;
        this.bufOut = ChannelUtils.isWritable(chan) ? new WritableByteChannelSource(buffer, chan) : null;
        if (this.bufIn == null && this.bufOut == null) {
            throw new IllegalArgumentException("Channel is neither readable, nor writable");
        }
        this.write = this.bufIn == null;
    }

    private void setRead() throws IOException {
        if (!this.canRead()) {
            throw new NonReadableSourceException();
        }
        if (this.write) {
            L.finest("setRead");
            this.flush();
            this.clear();
            this.write = false;
        }
    }

    private void setWrite() throws IOException {
        if (!this.canWrite()) {
            throw new NonWritableSourceException();
        }
        if (!this.write) {
            L.finest("setWrite");
            if (this.buf.hasRemaining()) {
                ((SeekableByteChannel)this.chan).position(((SeekableByteChannel)this.chan).position() - (long)this.buf.remaining());
            }
            this.clear();
            this.write = true;
        }
    }

    public void clear() {
        L.finest("clear");
        this.buf.limit(0);
    }

    @Override
    public boolean canRead() {
        return this.bufIn != null;
    }

    @Override
    public boolean canWrite() {
        return this.bufOut != null;
    }

    @Override
    public boolean canSeek() {
        return true;
    }

    @Override
    public boolean canGrow() {
        return this.canWrite() && this.bufOut.canGrow();
    }

    @Override
    public void flush() throws IOException {
        if (this.canWrite() && this.write) {
            this.bufOut.flush();
        }
    }

    @Override
    public long position() throws IOException {
        return this.write ? ((SeekableByteChannel)this.chan).position() + (long)this.buf.position() : ((SeekableByteChannel)this.chan).position() - (long)this.buf.remaining();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.setRead();
        return this.bufIn.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.setWrite();
        return this.bufOut.write(src);
    }

    @Override
    public ByteBuffer requestRead(int required) throws EOFException, IOException {
        this.setRead();
        return this.bufIn.requestRead(required);
    }

    @Override
    public ByteBuffer requestWrite(int required) throws EOFException, IOException {
        this.setWrite();
        return this.bufOut.requestWrite(required);
    }

    @Override
    public void position(long newPos) throws IOException {
        L.log(Level.FINEST, "postion: {0}", newPos);
        long pos = ((SeekableByteChannel)this.chan).position();
        boolean clear = false;
        if (this.write) {
            clear = true;
        } else if (newPos < pos + (long)this.buf.position() || newPos > pos + (long)this.buf.limit()) {
            L.finest("postion: outside read buffer");
            clear = true;
        }
        if (clear) {
            this.flush();
            pos = newPos;
            ((SeekableByteChannel)this.chan).position(pos);
            this.clear();
        }
        this.buf.position((int)(newPos - pos));
    }

    @Override
    public long size() throws IOException {
        return Math.max(((SeekableByteChannel)this.chan).size(), this.position());
    }

    public void truncate(long size) throws IOException {
        this.flush();
        this.clear();
        ((SeekableByteChannel)this.chan).truncate(size);
    }
}

