/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.buffer.source;

import info.ata4.io.buffer.source.ChannelSource;
import info.ata4.io.buffer.source.NonWritableSourceException;
import info.ata4.log.LogUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReadableByteChannelSource
extends ChannelSource<ReadableByteChannel> {
    private static final Logger L = LogUtils.getLogger();

    public ReadableByteChannelSource(ByteBuffer buf, ReadableByteChannel chan) {
        super(buf, chan);
    }

    @Override
    public int bufferSize() {
        return this.buf.capacity();
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean canGrow() {
        return false;
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    public void fill() throws IOException {
        this.buf.compact();
        this.buf.limit(this.buf.capacity());
        int start = this.buf.position();
        while (((ReadableByteChannel)this.chan).read(this.buf) > 0) {
        }
        L.log(Level.FINEST, "fill: {0} bytes read", this.buf.position() - start);
        this.buf.flip();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int n = this.chanBuf.read(dst);
        if (n == -1) {
            L.finest("read: buffer empty");
            if (dst.remaining() > this.buf.capacity()) {
                L.finest("read: read buffer directly");
                n = ((ReadableByteChannel)this.chan).read(dst);
            } else {
                this.fill();
                n = this.chanBuf.read(dst);
            }
        }
        return n;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new NonWritableSourceException();
    }

    @Override
    public ByteBuffer requestRead(int required) throws EOFException, IOException {
        if (this.buf.remaining() < required) {
            L.log(Level.FINEST, "requestRead: need {0} more bytes", required - this.buf.remaining());
            this.fill();
            if (this.buf.remaining() < required) {
                throw new EOFException();
            }
        }
        return this.buf;
    }

    @Override
    public ByteBuffer requestWrite(int required) throws EOFException, IOException {
        throw new NonWritableSourceException();
    }

    @Override
    public void close() throws IOException {
        ((ReadableByteChannel)this.chan).close();
    }
}

