/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io;

import info.ata4.io.DataBridge;
import info.ata4.io.DataOutput;
import info.ata4.io.StringOutput;
import info.ata4.io.Struct;
import info.ata4.io.buffer.source.BufferedSource;
import info.ata4.io.buffer.source.BufferedSourceChannel;
import info.ata4.io.util.HalfFloat;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class DataWriter
extends DataBridge
implements DataOutput,
StringOutput {
    public DataWriter(BufferedSource buf) {
        super(buf);
    }

    public void writeStruct(Struct struct) throws IOException {
        struct.write(this);
    }

    public OutputStream stream() {
        return Channels.newOutputStream(new BufferedSourceChannel(this.buf));
    }

    @Override
    public void writeBytes(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    @Override
    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.buf.requestWrite(len).put(b, off, len);
    }

    @Override
    public void writeBuffer(ByteBuffer src) throws IOException {
        while (src.hasRemaining() && this.buf.write(src) > 0) {
        }
        if (src.hasRemaining()) {
            throw new EOFException();
        }
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.buf.requestWrite(1).put(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.buf.requestWrite(1).put((byte)(v ? 1 : 0));
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.buf.requestWrite(2).putShort(v);
    }

    @Override
    public void writeChar(char v) throws IOException {
        this.buf.requestWrite(2).putChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.buf.requestWrite(4).putInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.buf.requestWrite(8).putLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.buf.requestWrite(4).putFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.buf.requestWrite(8).putDouble(v);
    }

    @Override
    public void writeUnsignedByte(int v) throws IOException {
        this.writeByte((byte)(v & 0xFF));
    }

    @Override
    public void writeUnsignedShort(int v) throws IOException {
        this.writeShort((short)(v & 0xFFFF));
    }

    @Override
    public void writeUnsignedInt(long v) throws IOException {
        this.writeInt((int)(v & 0xFFFFFFFFL));
    }

    @Override
    public void writeUnsignedLong(BigInteger v) throws IOException {
        this.writeBytes(v.toByteArray());
    }

    @Override
    public void writeHalf(float f) throws IOException {
        int sval = HalfFloat.floatToIntBits(f);
        this.writeUnsignedShort(sval);
    }

    @Override
    public void writeStringNull(String str, Charset charset) throws IOException {
        this.writeStringFixed(str, charset);
        this.writeUnsignedByte(0);
    }

    @Override
    public void writeStringNull(String str) throws IOException {
        this.writeStringNull(str, StandardCharsets.US_ASCII);
    }

    @Override
    public void writeStringFixed(String str, int length, Charset charset) throws IOException {
        byte[] raw = str.getBytes(charset);
        this.writeBytes(raw);
        int padding = length - raw.length;
        for (int i = 0; i < padding; ++i) {
            this.writeUnsignedByte(0);
        }
    }

    @Override
    public void writeStringFixed(String str, int length) throws IOException {
        this.writeStringFixed(str, length, StandardCharsets.US_ASCII);
    }

    @Override
    public void writeStringFixed(String str, Charset charset) throws IOException {
        this.writeBytes(str.getBytes(charset));
    }

    @Override
    public void writeStringFixed(String str) throws IOException {
        this.writeStringFixed(str, StandardCharsets.US_ASCII);
    }

    @Override
    public void writeStringPrefixed(String str, Class<? extends Number> prefixType, Charset charset) throws IOException {
        int len = str.length();
        if (prefixType == Byte.TYPE) {
            this.writeUnsignedByte(len);
        } else if (prefixType == Short.TYPE) {
            this.writeUnsignedShort(len);
        } else if (prefixType == Integer.TYPE) {
            this.writeUnsignedInt(len);
        } else {
            throw new IllegalArgumentException("Wrong prefix data type");
        }
        this.writeStringFixed(str, charset);
    }

    @Override
    public void writeStringPrefixed(String str, Class<? extends Number> prefixType) throws IOException {
        this.writeStringPrefixed(str, prefixType, StandardCharsets.US_ASCII);
    }
}

