/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io;

import info.ata4.io.DataReader;
import info.ata4.io.buffer.source.ByteBufferSource;
import info.ata4.io.buffer.source.ReadableByteChannelSource;
import info.ata4.io.buffer.source.SeekableByteChannelSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class DataReaders {
    public static DataReader forByteBuffer(ByteBuffer bb) {
        return new DataReader(new ByteBufferSource(bb));
    }

    public static DataReader forReadableByteChannel(ReadableByteChannel chan) throws IOException {
        ByteBuffer bb = ByteBuffer.allocateDirect(262144);
        ReadableByteChannelSource buf = new ReadableByteChannelSource(bb, chan);
        return new DataReader(buf);
    }

    public static DataReader forSeekableByteChannel(SeekableByteChannel chan) throws IOException {
        ByteBuffer bb = ByteBuffer.allocateDirect(65536);
        SeekableByteChannelSource buf = new SeekableByteChannelSource(bb, chan);
        return new DataReader(buf);
    }

    public static DataReader forInputStream(InputStream is) throws IOException {
        return DataReaders.forReadableByteChannel(Channels.newChannel(is));
    }

    public static DataReader forFile(Path path, OpenOption ... options) throws IOException {
        return DataReaders.forSeekableByteChannel(Files.newByteChannel(path, options));
    }

    private DataReaders() {
    }
}

