/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules.geom;

import info.ata4.bsplib.BspFileReader;
import info.ata4.bsplib.struct.DAreaportal;
import info.ata4.bsplib.struct.DDispInfo;
import info.ata4.bsplib.struct.DDispMultiBlend;
import info.ata4.bsplib.struct.DDispVert;
import info.ata4.bsplib.struct.DFace;
import info.ata4.bsplib.struct.DModel;
import info.ata4.bsplib.struct.DOccluderData;
import info.ata4.bsplib.struct.DOccluderPolyData;
import info.ata4.bsplib.vector.Vector3f;
import info.ata4.bspsrc.BspSourceConfig;
import info.ata4.bspsrc.VmfWriter;
import info.ata4.bspsrc.modules.ModuleDecompile;
import info.ata4.bspsrc.modules.VmfMeta;
import info.ata4.bspsrc.modules.texture.Texture;
import info.ata4.bspsrc.modules.texture.TextureAxis;
import info.ata4.bspsrc.modules.texture.TextureBuilder;
import info.ata4.bspsrc.modules.texture.TextureSource;
import info.ata4.bspsrc.util.Winding;
import info.ata4.bspsrc.util.WindingFactory;
import info.ata4.log.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FaceSource
extends ModuleDecompile {
    private static final Logger L = LogUtils.getLogger();
    private static final byte[] TRICONV = new byte[]{0, 0, 1, 0, 0, 0, 9};
    private static final float AREA_EPS = 1.0f;
    private final BspSourceConfig config;
    private final TextureSource texsrc;
    private final VmfMeta vmfmeta;
    public Map<Integer, Set<Integer>> origFaceToSplitFace = new HashMap<Integer, Set<Integer>>();
    private Set<Integer> undersizedFaces = new HashSet<Integer>();
    private int multiblendOffset;

    public FaceSource(BspFileReader reader, VmfWriter writer, BspSourceConfig config, TextureSource texsrc, VmfMeta vmfmeta) {
        super(reader, writer);
        this.config = config;
        this.texsrc = texsrc;
        this.vmfmeta = vmfmeta;
        if (this.bsp.origFaces.isEmpty()) {
            for (DFace face : this.bsp.faces) {
                face.origFace = -1;
            }
        } else {
            for (DFace face : this.bsp.faces) {
                if (face.origFace == -1) continue;
                this.bsp.origFaces.get((int)face.origFace).texinfo = face.texinfo;
            }
        }
    }

    public void writeFaces() {
        L.info("Writing split faces");
        DModel model = this.bsp.models.get(0);
        for (int i = 0; i < model.numface; ++i) {
            this.writeFace(model.fstface + i, false);
        }
    }

    public void writeOrigFaces() {
        L.info("Writing original faces");
        HashSet<Integer> writtenFaces = new HashSet<Integer>();
        DModel model = this.bsp.models.get(0);
        for (int i = 0; i < model.numface; ++i) {
            int iorigface;
            int iface = model.fstface + i;
            DFace face = this.bsp.faces.get(iface);
            if (face.origFace < 0 || writtenFaces.contains(iorigface = face.origFace)) continue;
            this.writeFace(iorigface, true);
            writtenFaces.add(iorigface);
        }
    }

    public void writeOrigFacesPlus() {
        this.createFaceMapping();
        HashSet<Integer> writtenFaces = new HashSet<Integer>();
        L.info("Writing original faces where possible");
        DModel model = this.bsp.models.get(0);
        int sfaces = 0;
        for (int i = 0; i < model.numface; ++i) {
            int iface = model.fstface + i;
            DFace face = this.bsp.faces.get(iface);
            if (face.origFace >= 0) {
                int iorigface = face.origFace;
                if (writtenFaces.contains(iorigface)) continue;
                if (this.undersizedFaces.contains(iorigface)) {
                    ++sfaces;
                    Set<Integer> faces = this.origFaceToSplitFace.get(face.origFace);
                    for (Integer iface2 : faces) {
                        this.writeFace(iface2, false);
                    }
                    if (L.isLoggable(Level.FINEST)) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("OF ").append(face.origFace).append(": ");
                        for (Integer findex : faces) {
                            sb.append(findex).append(' ');
                        }
                        L.finest(sb.toString());
                    }
                } else {
                    this.writeFace(face.origFace, true);
                }
                writtenFaces.add(iorigface);
                continue;
            }
            this.writeFace(iface, false);
        }
        L.log(Level.INFO, "{0} original faces were written as split faces", sfaces);
    }

    public void writeDispFaces() {
        L.info("Writing displacements");
        if (this.bsp.dispinfos == null || this.bsp.dispinfos.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.bsp.faces.size(); ++i) {
            if (this.bsp.faces.get((int)i).dispInfo == -1) continue;
            this.writeFace(i, false);
        }
    }

    public void writeModel(int imodel, Vector3f origin, Vector3f angles) {
        DModel model;
        try {
            model = this.bsp.models.get(imodel);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            L.log(Level.WARNING, "Invalid model index {0}", imodel);
            return;
        }
        for (int i = 0; i < model.numface; ++i) {
            this.writeFace(model.fstface + i, false, origin, angles);
        }
    }

    public void writeModel(int imodel) {
        this.writeModel(imodel, null, null);
    }

    public void writeFace(int iface, boolean orig, Vector3f origin, Vector3f angles) {
        boolean disp;
        Vector3f ev13;
        DFace face;
        DFace dFace = face = orig ? this.bsp.origFaces.get(iface) : this.bsp.faces.get(iface);
        if (face.numedge < 2) {
            return;
        }
        Winding wind = WindingFactory.fromFace(this.bsp, face);
        if (origin != null) {
            wind = wind.translate(origin);
        }
        if (angles != null) {
            wind = wind.rotate(angles);
        }
        Vector3f[] plane = wind.buildPlane();
        Vector3f e1 = plane[0];
        Vector3f e2 = plane[1];
        Vector3f e3 = plane[2];
        if (!(e1.isValid() && e2.isValid() && e3.isValid())) {
            L.log(Level.WARNING, "Face with wind {0} is invalid", wind);
            return;
        }
        Vector3f ev12 = e2.sub(e1);
        Vector3f normal = ev12.cross(ev13 = e3.sub(e1)).normalize();
        if (normal.isNaN() || normal.isInfinite()) {
            L.log(Level.FINE, "Bad normal: {0} x {1}", new Object[]{ev12, ev13});
            return;
        }
        this.writer.start("solid");
        this.writer.put("id", this.vmfmeta.getUID());
        if (this.config.isDebug()) {
            this.writer.start("bspsrc_debug");
            this.writer.put("face_index", iface);
            this.writer.put("normal", normal);
            this.writer.put("winding", wind.toString());
            if (face.texinfo != -1) {
                this.writer.put("texinfo_index", face.texinfo);
                this.writer.put("texinfo_flags", this.bsp.texinfos.get((int)face.texinfo).flags.toString());
            }
            this.writer.end("bspsrc_debug");
        }
        int sideID = this.vmfmeta.getUID();
        if (orig) {
            this.vmfmeta.setOrigFaceUID(iface, sideID);
        } else {
            this.vmfmeta.setFaceUID(iface, sideID);
        }
        TextureBuilder tb = this.texsrc.getTextureBuilder();
        tb.setOrigin(origin);
        tb.setAngles(angles);
        tb.setNormal(normal);
        tb.setTexinfoIndex(face.texinfo);
        Texture texture = tb.build();
        if (!this.config.faceTexture.isEmpty()) {
            texture.setOverrideTexture(this.config.faceTexture);
        }
        if (texture.getData() != null) {
            this.texsrc.addBrushSideID(texture.getData().texname, sideID);
        }
        this.writer.start("side");
        this.writer.put("id", sideID);
        this.writer.put("plane", e1, e2, e3);
        this.writer.put("smoothing_groups", face.smoothingGroups);
        this.writer.put(texture);
        boolean bl = disp = face.dispInfo != -1;
        if (disp && this.config.writeDisp) {
            this.vmfmeta.setDispInfoUID(face.dispInfo, sideID);
            this.writeDisplacement(face.dispInfo);
        }
        this.writer.end("side");
        if (!this.config.backfaceTexture.isEmpty()) {
            texture.setOverrideTexture(this.config.backfaceTexture);
        }
        if (disp) {
            this.writePrismBack(wind, texture);
        } else {
            this.writePyramBack(wind, texture);
        }
        this.writer.end("solid");
    }

    public void writeFace(int iface, boolean orig) {
        this.writeFace(iface, orig, null, null);
    }

    private void writePrismBack(Winding wind, Texture texture, float depth) {
        Vector3f[] plane = wind.buildPlane();
        Vector3f e1 = plane[0];
        Vector3f e2 = plane[1];
        Vector3f e3 = plane[2];
        Vector3f ev12 = e2.sub(e1);
        Vector3f ev13 = e3.sub(e1);
        Vector3f normal = ev12.cross(ev13).normalize();
        Vector3f bedge = normal.scalar(depth);
        e1 = e1.add(bedge);
        e2 = e2.add(bedge);
        e3 = e3.add(bedge);
        this.writeBackSide(texture, e1, e2, e3);
        Vector3f tv2 = bedge.normalize();
        int size = wind.size();
        for (int i = 0; i < size; ++i) {
            e1 = wind.get(i);
            e2 = wind.get((i + 1) % size);
            e3 = e1.add(bedge);
            Vector3f tv1 = e2.sub(e1).normalize();
            if (!tv1.isValid()) {
                tv1 = Vector3f.NULL;
            }
            texture.setUAxis(new TextureAxis(tv1));
            texture.setVAxis(new TextureAxis(tv2));
            this.writeBackSide(texture, e1, e2, e3);
        }
    }

    private void writePrismBack(Winding wind, Texture texture) {
        this.writePrismBack(wind, texture, this.config.backfaceDepth);
    }

    private void writePyramBack(Winding wind, Texture texture, float depth) {
        Vector3f[] plane = wind.buildPlane();
        Vector3f e1 = plane[0];
        Vector3f e2 = plane[1];
        Vector3f e3 = plane[2];
        Vector3f ev12 = e2.sub(e1);
        Vector3f ev13 = e3.sub(e1);
        Vector3f normal = ev12.cross(ev13).normalize();
        e3 = wind.getCenter();
        e3 = e3.add(normal.scalar(depth));
        int size = wind.size();
        for (int i = 0; i < size; ++i) {
            e1 = wind.get(i);
            e2 = wind.get((i + 1) % size);
            this.writeBackSide(texture, e1, e2, e3);
        }
    }

    private void writePyramBack(Winding wind, Texture texture) {
        this.writePyramBack(wind, texture, this.config.backfaceDepth);
    }

    public void writeAreaportal(int portalKey) {
        for (DAreaportal ap : this.bsp.areaportals) {
            if (ap.portalKey != portalKey) continue;
            this.writeAreaportal(ap);
            return;
        }
    }

    public void writeAreaportal(DAreaportal ap) {
        Winding wind = WindingFactory.fromAreaportal(this.bsp, ap);
        this.writePolygon(wind, "tools/toolsareaportal", true);
    }

    public void writeOccluder(int occluderKey) {
        try {
            this.writeOccluder(this.bsp.occluderDatas.get(occluderKey));
        }
        catch (IndexOutOfBoundsException ex) {
            L.log(Level.WARNING, "Invalid occluder key {0}", occluderKey);
        }
    }

    public void writeOccluder(DOccluderData od) {
        for (int i = 0; i < od.polycount; ++i) {
            DOccluderPolyData opd = this.bsp.occluderPolyDatas.get(od.firstpoly + i);
            Winding wind = WindingFactory.fromOccluder(this.bsp, opd);
            this.writePolygon(wind, "tools/toolsoccluder", "tools/toolsskip", true, 8.0f);
        }
    }

    public void writePolygon(Winding wind, String frontMaterial, String backMaterial, boolean prism, float depth) {
        Vector3f ev13;
        if (wind.isEmpty() || wind.size() < 3) {
            return;
        }
        Vector3f[] plane = wind.buildPlane();
        Vector3f e1 = plane[0];
        Vector3f e2 = plane[1];
        Vector3f e3 = plane[2];
        if (!(e1.isValid() && e2.isValid() && e3.isValid())) {
            L.log(Level.WARNING, "Areaportal with wind {0} is invalid", wind);
            return;
        }
        Vector3f ev12 = e2.sub(e1);
        Vector3f normal = ev12.cross(ev13 = e3.sub(e1)).normalize();
        if (normal.isNaN() || normal.isInfinite()) {
            L.log(Level.FINE, "Bad normal: {0} x {1}", new Object[]{ev12, ev13});
            return;
        }
        this.writer.start("solid");
        this.writer.put("id", this.vmfmeta.getUID());
        int sideID = this.vmfmeta.getUID();
        TextureBuilder tb = this.texsrc.getTextureBuilder();
        tb.setNormal(normal);
        Texture texture = tb.build();
        texture.setOriginalTexture(frontMaterial);
        this.writer.start("side");
        this.writer.put("id", sideID);
        this.writer.put("plane", e1, e2, e3);
        this.writer.put(texture);
        this.writer.end("side");
        texture.setOriginalTexture(backMaterial);
        if (prism) {
            this.writePrismBack(wind, texture, depth);
        } else {
            this.writePyramBack(wind, texture, depth);
        }
        this.writer.end("solid");
    }

    public void writePolygon(Winding wind, String frontMaterial, String backMaterial, boolean prism) {
        this.writePolygon(wind, frontMaterial, backMaterial, prism, this.config.backfaceDepth);
    }

    public void writePolygon(Winding wind, String material, boolean prism, float depth) {
        this.writePolygon(wind, material, material, prism, depth);
    }

    public void writePolygon(Winding wind, String material, boolean prism) {
        this.writePolygon(wind, material, material, prism);
    }

    private void writeBackSide(Texture texture, Vector3f e1, Vector3f e2, Vector3f e3) {
        this.writer.start("side");
        this.writer.put("id", this.vmfmeta.getUID());
        this.writer.put("plane", e1, e3, e2);
        this.writer.put("smoothing_groups", 0);
        this.writer.put(texture);
        this.writer.end("side");
    }

    public void writeDisplacement(int idispinfo) {
        int i;
        DDispInfo di = this.bsp.dispinfos.get(idispinfo);
        LinkedHashMap<String, String> normalMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> distanceMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> alphaMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> triangleTagMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> multiBlendMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> alphaBlendMap = new LinkedHashMap<String, String>();
        ArrayList multiBlendColorMaps = new ArrayList(4);
        for (int i2 = 0; i2 < 4; ++i2) {
            multiBlendColorMaps.add(new LinkedHashMap());
        }
        StringBuilder normalSb = new StringBuilder();
        StringBuilder distanceSb = new StringBuilder();
        StringBuilder alphaSb = new StringBuilder();
        StringBuilder multiblendSb = new StringBuilder();
        StringBuilder alphablendSb = new StringBuilder();
        ArrayList<StringBuilder> multiblendColorSbs = new ArrayList<StringBuilder>(4);
        for (int i3 = 0; i3 < 4; ++i3) {
            multiblendColorSbs.add(new StringBuilder());
        }
        StringBuilder triangleTagSb = new StringBuilder();
        StringBuilder allowedVertSb = new StringBuilder();
        int vertcount = di.getVertexCount();
        int psize = di.getPowerSize();
        boolean hasMultiBlend = !this.bsp.dispmultiblend.isEmpty() && di.hasMultiBlend();
        for (int i4 = 0; i4 < vertcount; ++i4) {
            int j;
            DDispVert dv = this.bsp.dispverts.get(di.dispVertStart + i4);
            DDispMultiBlend dmb = null;
            if (hasMultiBlend) {
                dmb = this.bsp.dispmultiblend.get(this.multiblendOffset + i4);
            }
            normalSb.append(dv.vector.x);
            normalSb.append(" ");
            normalSb.append(dv.vector.y);
            normalSb.append(" ");
            normalSb.append(dv.vector.z);
            distanceSb.append(dv.dist);
            alphaSb.append(dv.alpha);
            if (hasMultiBlend) {
                multiblendSb.append(dmb.multiblend.x);
                multiblendSb.append(" ");
                multiblendSb.append(dmb.multiblend.y);
                multiblendSb.append(" ");
                multiblendSb.append(dmb.multiblend.z);
                multiblendSb.append(" ");
                multiblendSb.append(dmb.multiblend.w);
                alphablendSb.append(dmb.alphablend.x);
                alphablendSb.append(" ");
                alphablendSb.append(dmb.alphablend.y);
                alphablendSb.append(" ");
                alphablendSb.append(dmb.alphablend.z);
                alphablendSb.append(" ");
                alphablendSb.append(dmb.alphablend.w);
                for (j = 0; j < dmb.multiblendcolors.length; ++j) {
                    StringBuilder mbcsb = (StringBuilder)multiblendColorSbs.get(j);
                    mbcsb.append(dmb.multiblendcolors[j].x);
                    mbcsb.append(" ");
                    mbcsb.append(dmb.multiblendcolors[j].y);
                    mbcsb.append(" ");
                    mbcsb.append(dmb.multiblendcolors[j].z);
                }
            }
            if (i4 % (psize + 1) == psize) {
                normalMap.put("row" + normalMap.size(), normalSb.toString());
                distanceMap.put("row" + distanceMap.size(), distanceSb.toString());
                alphaMap.put("row" + alphaMap.size(), alphaSb.toString());
                normalSb.setLength(0);
                distanceSb.setLength(0);
                alphaSb.setLength(0);
                if (!hasMultiBlend) continue;
                multiBlendMap.put("row" + multiBlendMap.size(), multiblendSb.toString());
                alphaBlendMap.put("row" + alphaBlendMap.size(), alphablendSb.toString());
                for (j = 0; j < dmb.multiblendcolors.length; ++j) {
                    Map multiBlendColorMap = (Map)multiBlendColorMaps.get(j);
                    multiBlendColorMap.put("row" + multiBlendColorMap.size(), ((StringBuilder)multiblendColorSbs.get(j)).toString());
                }
                multiblendSb.setLength(0);
                alphablendSb.setLength(0);
                for (j = 0; j < dmb.multiblendcolors.length; ++j) {
                    ((StringBuilder)multiblendColorSbs.get(j)).setLength(0);
                }
                continue;
            }
            normalSb.append(" ");
            distanceSb.append(" ");
            alphaSb.append(" ");
            if (!hasMultiBlend) continue;
            multiblendSb.append(" ");
            alphablendSb.append(" ");
            for (j = 0; j < dmb.multiblendcolors.length; ++j) {
                ((StringBuilder)multiblendColorSbs.get(j)).append(" ");
            }
        }
        if (hasMultiBlend) {
            this.multiblendOffset += vertcount;
        }
        int tcount = di.getTriangleTagCount();
        for (i = 0; i < tcount; ++i) {
            int dt = this.bsp.disptris.get((int)(di.dispTriStart + i)).tags;
            if (dt < 0 || dt > 6) {
                dt = 0;
            }
            triangleTagSb.append(TRICONV[dt]);
            if (i % 2 * psize == 2 * psize - 1) {
                triangleTagMap.put("row" + triangleTagMap.size(), triangleTagSb.toString());
                triangleTagSb.setLength(0);
                continue;
            }
            triangleTagSb.append(" ");
        }
        for (i = 0; i < di.allowedVerts.length; ++i) {
            allowedVertSb.append(di.allowedVerts[i]);
            if (i >= di.allowedVerts.length - 1) continue;
            allowedVertSb.append(" ");
        }
        this.writer.start("dispinfo");
        if (this.config.isDebug()) {
            this.writer.put("bspsrc_dispinfo_index", idispinfo);
        }
        this.writer.put("power", di.power);
        this.writer.put("startposition", di.startPos, 2);
        this.writer.put("elevation", 0);
        this.writer.put("subdiv", 0);
        this.writer.start("normals");
        this.writer.put(normalMap);
        this.writer.end("normals");
        this.writer.start("distances");
        this.writer.put(distanceMap);
        this.writer.end("distances");
        this.writer.start("alphas");
        this.writer.put(alphaMap);
        this.writer.end("alphas");
        this.writer.start("triangle_tags");
        this.writer.put(triangleTagMap);
        this.writer.end("triangle_tags");
        this.writer.start("allowed_verts");
        this.writer.put("10", allowedVertSb.toString());
        this.writer.end("allowed_verts");
        if (hasMultiBlend) {
            this.writer.start("multiblend");
            this.writer.put(multiBlendMap);
            this.writer.end("multiblend");
            this.writer.start("alphablend");
            this.writer.put(alphaBlendMap);
            this.writer.end("alphablend");
            for (int j = 0; j < 4; ++j) {
                this.writer.start("multiblend_color_" + j);
                this.writer.put((Map)multiBlendColorMaps.get(j));
                this.writer.end("multiblend_color_" + j);
            }
        }
        this.writer.end("dispinfo");
    }

    private void createFaceMapping() {
        int i;
        L.info("Building split face to original face maps");
        for (i = 0; i < this.bsp.faces.size(); ++i) {
            Set<Object> faceSet;
            int o = this.bsp.faces.get((int)i).origFace;
            if (o == -1) continue;
            if (this.origFaceToSplitFace.containsKey(o)) {
                faceSet = this.origFaceToSplitFace.get(o);
            } else {
                faceSet = new HashSet();
                this.origFaceToSplitFace.put(o, faceSet);
            }
            faceSet.add(i);
        }
        L.info("Building original face areas");
        for (i = 0; i < this.bsp.origFaces.size(); ++i) {
            DFace origFace = this.bsp.origFaces.get(i);
            if (origFace.area == 0.0f) {
                Winding wind = WindingFactory.fromFace(this.bsp, origFace);
                origFace.area = wind.getArea();
            }
            if (L.isLoggable(Level.FINEST)) {
                L.log(Level.FINEST, "OF {0}: area {1}", new Object[]{i, Float.valueOf(origFace.area)});
            }
            float carea = 0.0f;
            Set<Integer> faceSet = this.origFaceToSplitFace.get(i);
            for (Integer face : faceSet) {
                carea += this.bsp.faces.get((int)face.intValue()).area;
            }
            if (!(carea > origFace.area + 1.0f)) continue;
            this.undersizedFaces.add(i);
            if (!L.isLoggable(Level.FINEST)) continue;
            L.log(Level.FINEST, "OF {0} is undersized: {1}>{2}", new Object[]{i, Float.valueOf(carea), Float.valueOf(origFace.area)});
        }
    }
}

