/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules.entity;

import info.ata4.bsplib.BspFileReader;
import info.ata4.bsplib.entity.Entity;
import info.ata4.bsplib.entity.KeyValue;
import info.ata4.bsplib.struct.Color32;
import info.ata4.bsplib.struct.DAreaportal;
import info.ata4.bsplib.struct.DBrush;
import info.ata4.bsplib.struct.DBrushSide;
import info.ata4.bsplib.struct.DCubemapSample;
import info.ata4.bsplib.struct.DFace;
import info.ata4.bsplib.struct.DOverlay;
import info.ata4.bsplib.struct.DOverlayFade;
import info.ata4.bsplib.struct.DOverlaySystemLevel;
import info.ata4.bsplib.struct.DStaticProp;
import info.ata4.bsplib.struct.DStaticPropV10;
import info.ata4.bsplib.struct.DStaticPropV4;
import info.ata4.bsplib.struct.DStaticPropV5;
import info.ata4.bsplib.struct.DStaticPropV5Ship;
import info.ata4.bsplib.struct.DStaticPropV6;
import info.ata4.bsplib.struct.DStaticPropV7L4D;
import info.ata4.bsplib.struct.DStaticPropV8;
import info.ata4.bsplib.struct.DStaticPropV9;
import info.ata4.bsplib.vector.Vector3f;
import info.ata4.bspsrc.BspSourceConfig;
import info.ata4.bspsrc.VmfWriter;
import info.ata4.bspsrc.modules.BspProtection;
import info.ata4.bspsrc.modules.ModuleDecompile;
import info.ata4.bspsrc.modules.VmfMeta;
import info.ata4.bspsrc.modules.entity.Camera;
import info.ata4.bspsrc.modules.geom.BrushMode;
import info.ata4.bspsrc.modules.geom.BrushSource;
import info.ata4.bspsrc.modules.geom.BrushUtils;
import info.ata4.bspsrc.modules.geom.FaceSource;
import info.ata4.bspsrc.modules.texture.TextureSource;
import info.ata4.bspsrc.util.AABB;
import info.ata4.bspsrc.util.SourceFormat;
import info.ata4.bspsrc.util.Winding;
import info.ata4.bspsrc.util.WindingFactory;
import info.ata4.log.LogUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class EntitySource
extends ModuleDecompile {
    private static final Logger L = LogUtils.getLogger();
    private static final Pattern INSTANCE_PREFIX = Pattern.compile("^([^-]+)-");
    private final BspSourceConfig config;
    private final BrushSource brushsrc;
    private final FaceSource facesrc;
    private final TextureSource texsrc;
    private final BspProtection bspprot;
    private final VmfMeta vmfmeta;
    private final Set<Integer> apBrushes = new HashSet<Integer>();
    private final Map<Integer, String> overlayNames = new HashMap<Integer, String>();

    public EntitySource(BspFileReader reader, VmfWriter writer, BspSourceConfig config, BrushSource brushsrc, FaceSource facesrc, TextureSource texsrc, BspProtection bspprot, VmfMeta vmfmeta) {
        super(reader, writer);
        this.config = config;
        this.brushsrc = brushsrc;
        this.facesrc = facesrc;
        this.texsrc = texsrc;
        this.bspprot = bspprot;
        this.vmfmeta = vmfmeta;
        this.processEntities();
    }

    public void writeEntities() {
        L.info("Writing entities");
        boolean instances = this.bspFile.getVersion() >= 21;
        boolean fixRot = this.config.fixEntityRot && instances;
        ArrayList<String> visgroups = new ArrayList<String>();
        for (Entity ent : this.bsp.entities) {
            Matcher m;
            Vector3f angles;
            String occluderNumString;
            String portalNumString;
            String oidStr;
            boolean hasBrush;
            visgroups.clear();
            String className = ent.getClassName();
            if (className.equals("worldspawn")) continue;
            boolean isAreaportal = className.startsWith("func_areaportal");
            boolean isOccluder = className.equals("func_occluder");
            boolean bl = hasBrush = ent.getModelNum() > 0 || isAreaportal || isOccluder;
            if (!this.config.writePointEntities && !hasBrush || !this.config.writeBrushEntities && hasBrush || !this.config.writeAreaportals && isAreaportal || !this.config.writeOccluders && isOccluder || className.equals("info_ladder")) continue;
            if (className.equals("info_overlay_accessor") && (oidStr = ent.getValue("OverlayID")) != null && !oidStr.isEmpty()) {
                int oid = Integer.valueOf(oidStr);
                this.overlayNames.put(oid, ent.getTargetName());
                continue;
            }
            int entID = this.getHammerID(ent);
            if (entID == -1) {
                entID = this.vmfmeta.getUID();
            }
            this.writer.start("entity");
            this.writer.put("id", entID);
            int portalNum = -1;
            if (isAreaportal && (portalNumString = ent.getValue("portalnumber")) != null) {
                try {
                    portalNum = Integer.valueOf(portalNumString);
                }
                catch (NumberFormatException ex) {
                    portalNum = -1;
                }
                if (!this.config.isDebug()) {
                    ent.removeValue("portalnumber");
                }
            }
            int occluderNum = -1;
            if (isOccluder && (occluderNumString = ent.getValue("occludernumber")) != null) {
                try {
                    occluderNum = Integer.valueOf(occluderNumString);
                }
                catch (NumberFormatException ex) {
                    occluderNum = -1;
                }
                if (!this.config.isDebug()) {
                    ent.removeValue("occludernumber");
                }
            }
            int modelNum = ent.getModelNum();
            for (Map.Entry<String, String> kv : ent.getEntrySet()) {
                String key = kv.getKey();
                String value = kv.getValue();
                if (key.equals("angles") && modelNum >= 0 && fixRot || key.equals("origin") && modelNum == 0 || key.equals("model") && modelNum != -2 || key.equals("hammerid") || (isAreaportal || isOccluder) && (key.equals("angles") || key.equals("origin"))) continue;
                this.writer.put(key, value);
            }
            this.writer.put("classname", className);
            List<KeyValue> io = ent.getIO();
            if (!io.isEmpty()) {
                this.writer.start("connections");
                for (KeyValue kv : io) {
                    this.writer.put(kv);
                }
                this.writer.end("connections");
            }
            Vector3f origin = ent.getOrigin();
            Vector3f vector3f = angles = fixRot ? ent.getAngles() : null;
            if (modelNum > 0) {
                if (this.config.brushMode == BrushMode.BRUSHPLANES) {
                    this.brushsrc.writeModel(modelNum, origin, angles);
                } else {
                    this.facesrc.writeModel(modelNum, origin, angles);
                }
            } else {
                if (isAreaportal && portalNum != -1) {
                    int portalBrushNum = -1;
                    if (this.config.brushMode == BrushMode.BRUSHPLANES) {
                        portalBrushNum = this.findAreaportalBrush(portalNum);
                    }
                    if (portalBrushNum == -1) {
                        this.facesrc.writeAreaportal(portalNum);
                        visgroups.add("Rebuild areaportals");
                    } else {
                        this.brushsrc.writeBrush(portalBrushNum);
                        visgroups.add("Reallocated areaportals");
                    }
                }
                if (isOccluder && occluderNum != -1) {
                    this.facesrc.writeOccluder(occluderNum);
                    visgroups.add("Rebuild occluders");
                }
            }
            if (instances && ent.getTargetName() != null && (m = INSTANCE_PREFIX.matcher(ent.getTargetName())).find()) {
                visgroups.add(m.group(1));
            }
            if (this.bspprot.isProtectedEntity(ent)) {
                visgroups.add("VMEX flagged entities");
            }
            if (!visgroups.isEmpty()) {
                this.vmfmeta.writeMetaVisgroups(visgroups);
            }
            this.writer.end("entity");
        }
    }

    public void writeDetails() {
        List<DBrush> protBrushes;
        L.info("Writing func_details");
        if (this.config.detailMerge) {
            ArrayDeque<Pair<DBrush, AABB>> detailBrushes = new ArrayDeque<Pair<DBrush, AABB>>();
            HashMap<DBrush, Integer> detailBrushIndices = new HashMap<DBrush, Integer>();
            for (int i = 0; i < this.bsp.brushes.size(); ++i) {
                DBrush brush = this.bsp.brushes.get(i);
                if (!brush.isSolid() || !brush.isDetail() || this.bspprot.isProtectedBrush(brush)) continue;
                AABB bounds = BrushUtils.getBounds(this.bsp, brush);
                detailBrushes.add(new ImmutablePair<DBrush, AABB>(brush, bounds));
                detailBrushIndices.put(brush, i);
            }
            while (!detailBrushes.isEmpty()) {
                Pair detailBrush1 = (Pair)detailBrushes.remove();
                HashSet<Pair<DBrush, AABB>> detailBrushClump = new HashSet<Pair<DBrush, AABB>>();
                detailBrushClump.add(detailBrush1);
                this.clumpBrushes(detailBrushes, detailBrushClump, detailBrush1, this.config.detailMergeThresh);
                this.writer.start("entity");
                this.writer.put("id", this.vmfmeta.getUID());
                this.writer.put("classname", "func_detail");
                for (Pair pair : detailBrushClump) {
                    this.brushsrc.writeBrush((Integer)detailBrushIndices.get(pair.getLeft()));
                }
                this.writer.end("entity");
            }
        } else {
            for (int i = 0; i < this.bsp.brushes.size(); ++i) {
                DBrush brush = this.bsp.brushes.get(i);
                if (!brush.isSolid() || !brush.isDetail() || this.bspprot.isProtectedBrush(brush)) continue;
                this.writer.start("entity");
                this.writer.put("id", this.vmfmeta.getUID());
                this.writer.put("classname", "func_detail");
                this.brushsrc.writeBrush(i);
                this.writer.end("entity");
            }
        }
        if (!(protBrushes = this.bspprot.getProtectedBrushes()).isEmpty()) {
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "func_detail");
            this.vmfmeta.writeMetaVisgroup("VMEX protector brushes");
            for (DBrush protBrush : protBrushes) {
                this.brushsrc.writeBrush(this.bsp.brushes.indexOf(protBrush));
            }
            this.writer.end("entity");
        }
    }

    private void clumpBrushes(Collection<Pair<DBrush, AABB>> src, Collection<Pair<DBrush, AABB>> dst, Pair<DBrush, AABB> target, float thresh) {
        AABB targetBounds = target.getRight().expand(thresh);
        Iterator<Pair<DBrush, AABB>> iter = src.iterator();
        while (iter.hasNext()) {
            Pair<DBrush, AABB> other = iter.next();
            if (!other.getRight().intersectsWith(targetBounds)) continue;
            dst.add(other);
            iter.remove();
            this.clumpBrushes(src, dst, other, thresh);
            iter = src.iterator();
        }
    }

    public void writeOverlays() {
        L.info("Writing info_overlays");
        for (int i = 0; i < this.bsp.overlays.size(); ++i) {
            DOverlay o = this.bsp.overlays.get(i);
            Vector3f ubasis = new Vector3f(o.uvpoints[0].z, o.uvpoints[1].z, o.uvpoints[2].z);
            boolean vflip = o.uvpoints[3].z == 1.0f;
            for (int j = 0; j < 4; ++j) {
                o.uvpoints[j] = o.uvpoints[j].set(2, 0.0f);
            }
            Vector3f vbasis = o.basisNormal.cross(ubasis).normalize();
            if (vflip) {
                vbasis = vbasis.scalar(-1.0f);
            }
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "info_overlay");
            this.writer.put("material", this.texsrc.getTextureName(o.texinfo));
            this.writer.put("StartU", o.u[0]);
            this.writer.put("EndU", o.u[1]);
            this.writer.put("StartV", o.v[0]);
            this.writer.put("EndV", o.v[1]);
            this.writer.put("BasisOrigin", o.origin);
            this.writer.put("BasisU", ubasis);
            this.writer.put("BasisV", vbasis);
            this.writer.put("BasisNormal", o.basisNormal);
            this.writer.put("origin", o.origin);
            if (this.bsp.overlayFades != null && !this.bsp.overlayFades.isEmpty()) {
                DOverlayFade of = this.bsp.overlayFades.get(i);
                this.writer.put("fademindist", of.fadeDistMinSq);
                this.writer.put("fademaxdist", of.fadeDistMaxSq);
            }
            if (this.bsp.overlaySysLevels != null && !this.bsp.overlaySysLevels.isEmpty()) {
                DOverlaySystemLevel osl = this.bsp.overlaySysLevels.get(i);
                this.writer.put("mincpulevel", osl.minCPULevel);
                this.writer.put("maxcpulevel", osl.maxCPULevel);
                this.writer.put("mingpulevel", osl.minGPULevel);
                this.writer.put("maxgpulevel", osl.maxGPULevel);
            }
            for (int j = 0; j < 4; ++j) {
                this.writer.put("uv" + j, o.uvpoints[j]);
            }
            this.writer.put("RenderOrder", o.getRenderOrder());
            HashSet<Integer> sides = new HashSet<Integer>();
            int faceCount = o.getFaceCount();
            if (this.config.brushMode == BrushMode.BRUSHPLANES) {
                HashSet<Integer> origFaces = new HashSet<Integer>();
                for (int j = 0; j < faceCount; ++j) {
                    int iface = o.ofaces[j];
                    int ioface = this.bsp.faces.get((int)iface).origFace;
                    if (ioface <= 0) continue;
                    origFaces.add(ioface);
                }
                for (Integer ioface : origFaces) {
                    this.findOverlayFaces(i, ioface, sides);
                }
            } else {
                for (int j = 0; j < faceCount; ++j) {
                    int iface = o.ofaces[j];
                    int faceId = this.vmfmeta.getFaceUID(iface);
                    if (faceId == -1) continue;
                    sides.add(faceId);
                }
            }
            StringBuilder sb = new StringBuilder();
            for (Integer side : sides) {
                sb.append(side);
                sb.append(" ");
            }
            this.writer.put("sides", sb.toString());
            if (this.overlayNames.containsKey(o.id)) {
                this.writer.put("targetname", this.overlayNames.get(o.id));
            }
            this.writer.end("entity");
        }
    }

    public void writeStaticProps() {
        L.info("Writing prop_statics");
        LinkedHashMap<Vector3f, String> lightingOrigins = new LinkedHashMap<Vector3f, String>();
        for (DStaticProp pst : this.bsp.staticProps) {
            DStaticPropV4 pst4 = (DStaticPropV4)pst;
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "prop_static");
            this.writer.put("origin", pst4.origin);
            this.writer.put("angles", pst4.angles);
            this.writer.put("skin", pst4.skin);
            this.writer.put("fademindist", pst4.fademin == 0.0f ? -1.0f : pst4.fademin);
            this.writer.put("fademaxdist", pst4.fademax);
            this.writer.put("solid", pst4.solid);
            this.writer.put("model", this.bsp.staticPropName.get(pst4.propType));
            if (pst4.usesLightingOrigin()) {
                String infoLightingName;
                if (lightingOrigins.containsKey(pst4.lightingOrigin)) {
                    infoLightingName = (String)lightingOrigins.get(pst4.lightingOrigin);
                } else {
                    infoLightingName = "sprp_lighting_" + lightingOrigins.size();
                    lightingOrigins.put(pst4.lightingOrigin, infoLightingName);
                }
                this.writer.put("lightingorigin", infoLightingName);
            }
            this.writer.put("disableshadows", pst4.hasNoShadowing());
            if (pst instanceof DStaticPropV5) {
                DStaticPropV5 pst5 = (DStaticPropV5)pst;
                this.writer.put("fadescale", pst5.forcedFadeScale);
                this.writer.put("disableselfshadowing", pst5.hasNoSelfShadowing());
                this.writer.put("disablevertexlighting", pst5.hasNoPerVertexLighting());
            }
            if (pst instanceof DStaticPropV6) {
                DStaticPropV6 pst6 = (DStaticPropV6)pst;
                this.writer.put("maxdxlevel", pst6.maxDXLevel);
                this.writer.put("mindxlevel", pst6.minDXLevel);
                this.writer.put("ignorenormals", pst6.hasIgnoreNormals());
            }
            Color32 diffMod = null;
            if (pst instanceof DStaticPropV7L4D) {
                DStaticPropV7L4D pst7 = (DStaticPropV7L4D)pst;
                diffMod = pst7.diffuseModulation;
            }
            if (pst instanceof DStaticPropV8) {
                DStaticPropV8 pst8 = (DStaticPropV8)pst;
                diffMod = pst8.diffuseModulation;
                this.writer.put("maxcpulevel", pst8.maxCPULevel);
                this.writer.put("mincpulevel", pst8.minCPULevel);
                this.writer.put("maxgpulevel", pst8.maxGPULevel);
                this.writer.put("mingpulevel", pst8.minGPULevel);
            }
            if (diffMod != null) {
                this.writer.put("rendercolor", String.format("%d %d %d", diffMod.r, diffMod.g, diffMod.b));
                this.writer.put("renderamt", diffMod.a);
            }
            if (pst instanceof DStaticPropV9) {
                DStaticPropV9 pst9 = (DStaticPropV9)pst;
                this.writer.put("disableX360", pst9.disableX360);
            }
            if (pst instanceof DStaticPropV5Ship) {
                this.writer.put("targetname", ((DStaticPropV5Ship)pst).targetname);
            }
            if (pst instanceof DStaticPropV10) {
                DStaticPropV10 psttf2 = (DStaticPropV10)pst;
                boolean genLightmaps = !psttf2.hasNoPerTexelLighting();
                this.writer.put("generatelightmaps", genLightmaps);
                if (genLightmaps) {
                    this.writer.put("lightmapresolutionx", psttf2.lightmapResolutionX);
                    this.writer.put("lightmapresolutiony", psttf2.lightmapResolutionY);
                }
            }
            this.writer.end("entity");
        }
        for (Vector3f origin : lightingOrigins.keySet()) {
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "info_lighting");
            this.writer.put("targetname", lightingOrigins.get(origin));
            this.writer.put("origin", origin);
            this.writer.end("entity");
        }
    }

    public void writeCubemaps() {
        L.info("Writing env_cubemaps");
        for (int i = 0; i < this.bsp.cubemaps.size(); ++i) {
            DCubemapSample cm = this.bsp.cubemaps.get(i);
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "env_cubemap");
            this.writer.put("origin", new Vector3f(cm.origin[0], cm.origin[1], cm.origin[2]));
            this.writer.put("cubemapsize", cm.size);
            Set<Integer> sideList = this.texsrc.getBrushSidesForCubemap(i);
            if (sideList != null) {
                int cmSides = sideList.size();
                if (cmSides > this.config.maxCubemapSides) {
                    L.log(Level.FINER, "Cubemap {0} has too many sides: {1}", new Object[]{i, sideList});
                }
                if (cmSides > 0 && cmSides < this.config.maxCubemapSides) {
                    StringBuilder sb = new StringBuilder();
                    for (int sideId : sideList) {
                        sb.append(sideId);
                        sb.append(" ");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    this.writer.put("sides", sb.toString());
                }
            }
            this.writer.end("entity");
        }
    }

    public void writeLadders() {
        L.info("Writing func_ladders");
        for (int i = 0; i < this.bsp.brushes.size(); ++i) {
            DBrush brush = this.bsp.brushes.get(i);
            if (!brush.isLadder()) continue;
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "func_ladder");
            this.brushsrc.writeBrush(i);
            this.writer.end("entity");
        }
    }

    private int findAreaportalBrush(int portalnum) {
        if (this.bsp.areaportals.isEmpty()) {
            return -1;
        }
        DAreaportal ap = null;
        for (DAreaportal areaportal : this.bsp.areaportals) {
            if (areaportal.portalKey != portalnum) continue;
            ap = areaportal;
            break;
        }
        if (ap == null) {
            L.log(Level.FINER, "No portal geometry for portal key {0}", portalnum);
            return -1;
        }
        Winding wp = WindingFactory.fromAreaportal(this.bsp, ap);
        for (int i = 0; i < this.bsp.brushes.size(); ++i) {
            DBrush brush = this.bsp.brushes.get(i);
            if (!brush.isAreaportal() || this.apBrushes.contains(i)) continue;
            for (int j = 0; j < brush.numside; ++j) {
                Winding w = WindingFactory.fromSide(this.bsp, brush, j);
                if (!w.matches(wp)) continue;
                L.log(Level.FINER, "Brush {0} for portal key {1}", new Object[]{i, portalnum});
                this.apBrushes.add(i);
                return i;
            }
        }
        L.log(Level.FINER, "No brush for portal key {0}", portalnum);
        return -1;
    }

    private void findOverlayFaces(int ioverlay, int ioface, Set<Integer> sides) {
        if (this.bsp.origFaces.isEmpty()) {
            return;
        }
        if (sides.size() >= this.config.maxOverlaySides) {
            return;
        }
        int sidesPrev = sides.size();
        DFace origFace = this.bsp.origFaces.get(ioface);
        if (origFace.dispInfo != -1) {
            int side = this.vmfmeta.getDispInfoUID(origFace.dispInfo);
            if (side != -1) {
                L.log(Level.FINER, "O: {0} D: {1} id: {2}", new Object[]{ioverlay, origFace.dispInfo, side});
                sides.add(side);
            }
            return;
        }
        Winding wof = WindingFactory.fromFace(this.bsp, origFace);
        block0: for (int i = 0; i < this.bsp.brushes.size(); ++i) {
            DBrush brush = this.bsp.brushes.get(i);
            for (int j = 0; j < brush.numside; ++j) {
                int ibs = brush.fstside + j;
                int side = this.brushsrc.getBrushSideIDForIndex(ibs);
                if (side == -1) continue;
                DBrushSide bs = this.bsp.brushSides.get(ibs);
                Winding w = WindingFactory.fromSide(this.bsp, brush, j);
                if (origFace.pnum != bs.pnum || origFace.texinfo != bs.texinfo || !w.matches(wof)) continue;
                L.log(Level.FINER, "O: {0} OF: {1} B: {2} BS: {3} id: {4}", new Object[]{ioverlay, ioface, i, ibs, side});
                sides.add(side);
                if (sides.size() < this.config.maxOverlaySides) continue;
                L.log(Level.WARNING, "Too many brush sides for overlay {0}", ioverlay);
                continue block0;
            }
        }
        if (sides.size() == sidesPrev) {
            L.log(Level.FINER, "O: {0} OF: {1} no match", new Object[]{ioverlay, ioface});
        }
    }

    private void processEntities() {
        for (Entity ent : this.bsp.entities) {
            int hammerid;
            String className = ent.getClassName();
            if (className.equals("worldspawn")) {
                ent.removeValue("world_mins");
                ent.removeValue("world_maxs");
                ent.removeValue("hammerid");
                if (!ent.hasKey("mapversion")) {
                    ent.setValue("mapversion", this.bspFile.getRevision());
                }
            }
            if (this.config.sourceFormat != SourceFormat.AUTO) {
                char dstSep;
                char srcSep;
                if (this.config.sourceFormat == SourceFormat.NEW) {
                    srcSep = ',';
                    dstSep = '\u001b';
                } else {
                    srcSep = '\u001b';
                    dstSep = ',';
                }
                for (KeyValue kv : ent.getIO()) {
                    String value = kv.getValue();
                    value = value.replace(srcSep, dstSep);
                    kv.setValue(value);
                }
            }
            if (this.bspFile.getSourceApp().getAppID() == 2600) {
                String value;
                for (Map.Entry<String, String> kv : ent.getEntrySet()) {
                    value = kv.getValue();
                    value = value.replace("\\\"", "");
                    kv.setValue(value);
                }
                for (KeyValue kv : ent.getIO()) {
                    value = kv.getValue();
                    value = value.replace("\\\"", "");
                    kv.setValue(value);
                }
            }
            if (className.equals("func_simpleladder")) {
                int modelNum = ent.getModelNum();
                ent.clear();
                ent.setClassName("func_ladder");
                ent.setModelNum(modelNum);
            }
            if (className.startsWith("light") && !className.equals("light_dynamic")) {
                this.fixLightEntity(ent);
            }
            if (className.startsWith("info_player_")) {
                this.createCamera(ent);
            }
            if ((hammerid = this.getHammerID(ent)) == -1) continue;
            this.vmfmeta.getUIDBlackList().add(hammerid);
        }
    }

    private int getHammerID(Entity ent) {
        String keyName = "hammerid";
        if (!ent.hasKey(keyName)) {
            return -1;
        }
        String hammeridStr = ent.getValue(keyName);
        int hammerid = -1;
        try {
            hammerid = Integer.parseInt(ent.getValue("hammerid"));
        }
        catch (NumberFormatException ex) {
            L.log(Level.WARNING, "Invalid hammerid format {0}", hammeridStr);
        }
        return hammerid;
    }

    private void fixLightEntity(Entity ent) {
        String style = ent.getValue("style");
        String defaultStyle = ent.getValue("defaultstyle");
        if (style == null) {
            return;
        }
        try {
            if (Integer.valueOf(style) < 32) {
                return;
            }
        }
        catch (NumberFormatException ex) {
            L.log(Level.WARNING, "Invalid light style number format: {0}", style);
        }
        if (defaultStyle != null) {
            ent.setValue("style", defaultStyle);
            ent.removeValue("defaultstyle");
        } else {
            ent.removeValue("style");
        }
    }

    private void createCamera(Entity ent) {
        Vector3f origin = ent.getOrigin();
        Vector3f angles = ent.getAngles();
        if (origin == null) {
            return;
        }
        if (angles == null) {
            angles = Vector3f.NULL;
        }
        Vector3f pos = origin.add(new Vector3f(0.0f, 0.0f, 64.0f));
        Vector3f look = new Vector3f(192.0f, 0.0f, 0.0f).rotate(angles).add(origin);
        pos = look.sub(pos).normalize().scalar(-64.0f).add(pos);
        this.vmfmeta.getCameras().add(new Camera(pos, look));
    }
}

