/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules;

import info.ata4.bsplib.BspFileReader;
import info.ata4.bsplib.entity.Entity;
import info.ata4.bspsrc.VmfWriter;
import info.ata4.bspsrc.modules.ModuleDecompile;
import info.ata4.bspsrc.modules.entity.Camera;
import info.ata4.log.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VmfMeta
extends ModuleDecompile {
    private static final Logger L = LogUtils.getLogger();
    private Map<Integer, Integer> faceUIDs = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> origFaceUIDs = new HashMap<Integer, Integer>();
    private Map<Short, Integer> dispinfoUIDs = new HashMap<Short, Integer>();
    private Set<Integer> uidbl = new HashSet<Integer>();
    private int uid = 0;
    private List<String> visgroups = new ArrayList<String>();
    private List<Camera> cameras = new ArrayList<Camera>();
    private Entity worldspawn;
    private String comment;

    public VmfMeta(BspFileReader reader, VmfWriter writer) {
        super(reader, writer);
        this.worldspawn = this.bsp.entities.get(0);
        if (this.worldspawn.getValue("comment") != null) {
            L.log(Level.INFO, "Map comment: {0}", this.worldspawn.getValue("comment"));
        }
    }

    public Set<Integer> getUIDBlackList() {
        return this.uidbl;
    }

    public int getUID() {
        if (this.uidbl.isEmpty()) {
            return this.uid++;
        }
        do {
            ++this.uid;
        } while (this.uidbl.contains(this.uid));
        return this.uid;
    }

    public int getFaceUID(int iface) {
        if (this.faceUIDs.containsKey(iface)) {
            return this.faceUIDs.get(iface);
        }
        int ioface = this.bsp.faces.get((int)iface).origFace;
        if (this.origFaceUIDs.containsKey(ioface)) {
            return this.origFaceUIDs.get(ioface);
        }
        return -1;
    }

    public Integer setFaceUID(int iface, int id) {
        return this.faceUIDs.put(iface, id);
    }

    public Integer setOrigFaceUID(int iface, int id) {
        return this.origFaceUIDs.put(iface, id);
    }

    public int getDispInfoUID(short idispinfo) {
        if (this.dispinfoUIDs.containsKey(idispinfo)) {
            return this.dispinfoUIDs.get(idispinfo);
        }
        return -1;
    }

    public Integer setDispInfoUID(short idispinfo, int id) {
        return this.dispinfoUIDs.put(idispinfo, id);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void writeWorldHeader() {
        this.writer.start("world");
        this.writer.put("id", this.getUID());
        this.writer.put(this.worldspawn);
        if (this.comment != null) {
            this.writer.put("comment", this.comment);
        }
        this.writer.put("classname", "worldspawn");
    }

    public void writeWorldFooter() {
        this.writer.end("world");
    }

    public void writeVisgroups() {
        if (this.visgroups.isEmpty()) {
            return;
        }
        String[] visgroupArray = this.visgroups.toArray(new String[0]);
        this.writer.start("visgroups");
        for (String visgroup : visgroupArray) {
            this.writer.start("visgroup");
            this.writer.put("name", visgroup);
            this.writer.put("visgroupid", this.visgroups.indexOf(visgroup));
            this.writer.end("visgroup");
        }
        this.writer.end("visgroups");
    }

    public void writeMetaVisgroup(String visgroupName) {
        this.writer.start("editor");
        this.writer.put("visgroupid", this.getVisgroupID(visgroupName));
        this.writer.end("editor");
    }

    public void writeMetaVisgroups(List<String> visgroupNames) {
        this.writer.start("editor");
        for (String visgroupName : visgroupNames) {
            this.writer.put("visgroupid", this.getVisgroupID(visgroupName));
        }
        this.writer.end("editor");
    }

    public int getVisgroupID(String visgroupName) {
        if (!this.visgroups.contains(visgroupName)) {
            this.visgroups.add(visgroupName);
        }
        return this.visgroups.indexOf(visgroupName);
    }

    public void writeCameras() {
        this.writer.start("cameras");
        if (this.cameras.isEmpty()) {
            this.writer.put("activecamera", -1);
        } else {
            this.writer.put("activecamera", 0);
            for (Camera camera : this.cameras) {
                this.writer.start("camera");
                this.writer.put("position", camera.pos, 2);
                this.writer.put("look", camera.look, 2);
                this.writer.end("camera");
            }
        }
        this.writer.end("cameras");
    }

    public List<Camera> getCameras() {
        return this.cameras;
    }
}

