/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules;

import info.ata4.bsplib.BspFileReader;
import info.ata4.bsplib.lump.LumpType;
import info.ata4.bsplib.struct.LevelFlag;
import info.ata4.bspsrc.modules.ModuleRead;
import info.ata4.log.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class BspCompileParams
extends ModuleRead {
    private static final Logger L = LogUtils.getLogger();
    private List<String> vbspParams = new ArrayList<String>();
    private List<String> vvisParams = new ArrayList<String>();
    private List<String> vradParams = new ArrayList<String>();
    private boolean vvisRun = false;
    private boolean vradRun = false;

    public BspCompileParams(BspFileReader reader) {
        super(reader);
        reader.loadFlags();
        boolean stale = false;
        boolean hasVhv = false;
        try (ZipArchiveInputStream zis = this.bspFile.getPakFile().getArchiveInputStream();){
            ZipArchiveEntry ze;
            while ((ze = zis.getNextZipEntry()) != null) {
                if (ze.getName().equals("stale.txt")) {
                    stale = true;
                }
                if (ze.getName().endsWith(".vhv")) {
                    hasVhv = true;
                }
                if (!stale || !hasVhv) continue;
                break;
            }
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Couldn''t read pakfile", ex);
        }
        if (stale) {
            this.vbspParams.add("-onlyents/-keepstalezip");
        }
        this.vvisRun = this.bspFile.getLump(LumpType.LUMP_VISIBILITY).getLength() > 0;
        boolean sprpLight = false;
        if (this.bsp.mapFlags != null) {
            sprpLight = this.bsp.mapFlags.contains((Object)LevelFlag.LVLFLAGS_BAKED_STATIC_PROP_LIGHTING_HDR) || this.bsp.mapFlags.contains((Object)LevelFlag.LVLFLAGS_BAKED_STATIC_PROP_LIGHTING_NONHDR);
        }
        boolean ldr = this.bspFile.getLump(LumpType.LUMP_LIGHTING).getLength() > 0;
        boolean hdr = this.bspFile.getLump(LumpType.LUMP_LIGHTING_HDR).getLength() > 0;
        boolean bl = this.vradRun = ldr || hdr;
        if (this.vradRun) {
            if (ldr && hdr) {
                this.vradParams.add("-both");
            } else if (ldr) {
                this.vradParams.add("-ldr");
            } else if (hdr) {
                this.vradParams.add("-hdr");
            }
            if (sprpLight || hasVhv) {
                this.vradParams.add("-StaticPropLighting");
            }
        }
    }

    public List<String> getVbspParams() {
        return Collections.unmodifiableList(this.vbspParams);
    }

    public List<String> getVvisParams() {
        return Collections.unmodifiableList(this.vvisParams);
    }

    public List<String> getVradParams() {
        return Collections.unmodifiableList(this.vradParams);
    }

    public boolean isVvisRun() {
        return this.vvisRun;
    }

    public boolean isVradRun() {
        return this.vradRun;
    }
}

