/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.gui;

import info.ata4.bsplib.BspFileFilter;
import info.ata4.bsplib.app.SourceApp;
import info.ata4.bsplib.app.SourceAppDB;
import info.ata4.bspsrc.BspFileEntry;
import info.ata4.bspsrc.BspSource;
import info.ata4.bspsrc.BspSourceConfig;
import info.ata4.bspsrc.gui.BspSourceLogFrame;
import info.ata4.bspsrc.gui.util.EnumToolTexture;
import info.ata4.bspsrc.modules.geom.BrushMode;
import info.ata4.bspsrc.util.SourceFormat;
import info.ata4.log.LogUtils;
import info.ata4.util.gui.FileDrop;
import info.ata4.util.gui.FileExtensionFilter;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class BspSourceFrame
extends JFrame {
    private static final Logger L = LogUtils.getLogger();
    private BspSourceConfig config;
    private BspSourceLogFrame logFrame;
    private FileDrop fdrop;
    private DefaultListModel<BspFileEntry> listFilesModel = new DefaultListModel();
    private JButton buttonAdd;
    private JButton buttonDecompile;
    private JButton buttonDefaults;
    private ButtonGroup buttonGroupBrushMode;
    private JButton buttonRemove;
    private JButton buttonRemoveAll;
    private JCheckBox checkBoxAreaportal;
    private JCheckBox checkBoxCameras;
    private JCheckBox checkBoxCubemap;
    private JCheckBox checkBoxDebugMode;
    private JCheckBox checkBoxDetail;
    private JCheckBox checkBoxDisp;
    private JCheckBox checkBoxEnableEntities;
    private JCheckBox checkBoxEnableWorldBrushes;
    private JCheckBox checkBoxExtractEmbedded;
    private JCheckBox checkBoxFixCubemapTex;
    private JCheckBox checkBoxFixRotation;
    private JCheckBox checkBoxFixToolTex;
    private JCheckBox checkBoxLadder;
    private JCheckBox checkBoxLoadLumpFile;
    private JCheckBox checkBoxOccluder;
    private JCheckBox checkBoxOverlay;
    private JCheckBox checkBoxPropStatic;
    private JCheckBox checkBoxVisgroups;
    private JComboBox comboBoxBackfaceTex;
    private JComboBox comboBoxFaceTex;
    private JComboBox comboBoxMapFormat;
    private JComboBox comboBoxSourceFormat;
    private JLabel labelBackfaceTex;
    private JLabel labelDnDTip;
    private JLabel labelFaceTex;
    private JLabel labelMapFormat;
    private JLabel labelSourceFormat;
    private JList listFiles;
    private JPanel panelBrushEnts;
    private JPanel panelBrushMode;
    private JPanel panelEntities;
    private JPanel panelFiles;
    private JPanel panelOther;
    private JPanel panelPointEnts;
    private JPanel panelTextures;
    private JPanel panelWorldBrushes;
    private JRadioButton radioButtonBrushesPlanes;
    private JRadioButton radioButtonOrigFaces;
    private JRadioButton radioButtonOrigSplitFaces;
    private JRadioButton radioButtonSplitFaces;
    private JScrollPane scrollFiles;
    private JTabbedPane tabbedPaneOptions;

    public static void main(String[] args) {
        LogUtils.configure();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            L.warning("Failed to set SystemLookAndFeel");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new BspSourceFrame().setVisible(true);
            }
        });
    }

    public BspSourceFrame() {
        this.initComponents();
        this.initComponentsCustom();
        this.reset();
        this.fdrop = new FileDrop(this.listFiles, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                BspFileFilter filter = new BspFileFilter();
                for (File file : files) {
                    if (file.isDirectory()) {
                        File[] subFiles;
                        for (File subFile : subFiles = file.listFiles(filter)) {
                            BspSourceFrame.this.listFilesModel.addElement(new BspFileEntry(subFile));
                        }
                        continue;
                    }
                    if (!filter.accept(file)) continue;
                    BspSourceFrame.this.listFilesModel.addElement(new BspFileEntry(file));
                }
                BspSourceFrame.this.buttonDecompile.setEnabled(!BspSourceFrame.this.listFilesModel.isEmpty());
            }
        });
    }

    public ComboBoxModel getFaceTextureModel() {
        return new DefaultComboBoxModel<EnumToolTexture>(EnumToolTexture.values());
    }

    public ComboBoxModel getAppIDModel() {
        DefaultComboBoxModel<SourceApp> cbmodel = new DefaultComboBoxModel<SourceApp>();
        cbmodel.addElement(new SourceApp("Automatic", 0));
        List<SourceApp> apps = SourceAppDB.getInstance().getAppList();
        for (SourceApp app : apps) {
            cbmodel.addElement(app);
        }
        return cbmodel;
    }

    public ComboBoxModel getBrushModeModel() {
        return new DefaultComboBoxModel<BrushMode>(BrushMode.values());
    }

    public ComboBoxModel getSourceFormatModel() {
        return new DefaultComboBoxModel<SourceFormat>(SourceFormat.values());
    }

    public ListModel getFilesModel() {
        return this.listFilesModel;
    }

    public final void reset() {
        this.config = new BspSourceConfig();
        this.checkBoxAreaportal.setSelected(this.config.writeAreaportals);
        this.checkBoxCubemap.setSelected(this.config.writeCubemaps);
        this.checkBoxDebugMode.setSelected(this.config.isDebug());
        this.checkBoxDetail.setSelected(this.config.writeDetails);
        this.checkBoxDisp.setSelected(this.config.writeDisp);
        this.checkBoxFixToolTex.setSelected(this.config.fixToolTextures);
        this.checkBoxFixCubemapTex.setSelected(this.config.fixCubemapTextures);
        this.checkBoxFixRotation.setSelected(this.config.fixEntityRot);
        this.checkBoxLoadLumpFile.setSelected(this.config.loadLumpFiles);
        this.checkBoxOccluder.setSelected(this.config.writeOccluders);
        this.checkBoxLadder.setSelected(this.config.writeLadders);
        this.checkBoxOverlay.setSelected(this.config.writeOverlays);
        this.checkBoxPropStatic.setSelected(this.config.writeStaticProps);
        this.checkBoxVisgroups.setSelected(this.config.writeVisgroups);
        this.checkBoxCameras.setSelected(this.config.writeCameras);
        this.checkBoxExtractEmbedded.setSelected(this.config.unpackEmbedded);
        this.checkBoxEnableEntities.setSelected(this.config.isWriteEntities());
        this.setPanelEnabled(this.panelEntities, this.checkBoxEnableEntities);
        this.checkBoxEnableWorldBrushes.setSelected(this.config.writeWorldBrushes);
        this.setPanelEnabled(this.panelWorldBrushes, this.checkBoxEnableWorldBrushes);
        this.comboBoxBackfaceTex.setSelectedIndex(0);
        this.comboBoxFaceTex.setSelectedIndex(0);
        this.listFilesModel.removeAllElements();
        switch (this.config.brushMode) {
            case BRUSHPLANES: {
                this.radioButtonBrushesPlanes.setSelected(true);
                break;
            }
            case ORIGFACE: {
                this.radioButtonOrigFaces.setSelected(true);
                break;
            }
            case ORIGFACE_PLUS: {
                this.radioButtonOrigSplitFaces.setSelected(true);
                break;
            }
            case SPLITFACE: {
                this.radioButtonSplitFaces.setSelected(true);
            }
        }
        this.buttonDecompile.setEnabled(false);
    }

    public void setButtonsEnabled(boolean value) {
        this.buttonDecompile.setEnabled(value);
        this.buttonDefaults.setEnabled(value);
    }

    private void setPanelEnabled(JPanel panel, JCheckBox checkbox) {
        Component[] comps;
        for (Component comp : comps = panel.getComponents()) {
            if (comp == checkbox) continue;
            if (comp instanceof JPanel) {
                this.setPanelEnabled((JPanel)comp, checkbox);
            }
            comp.setEnabled(checkbox.isSelected());
        }
    }

    private File[] openFileDialog(File defaultFile, FileFilter filter) {
        JFileChooser fc = new JFileChooser(){

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                if (file != null && !file.exists()) {
                    this.showFileNotFoundDialog();
                    return;
                }
                super.approveSelection();
            }

            private void showFileNotFoundDialog() {
                JOptionPane.showMessageDialog(this, "The selected file doesn't exist.");
            }
        };
        fc.setMultiSelectionEnabled(true);
        fc.setFileFilter(filter);
        if (defaultFile != null) {
            fc.setSelectedFile(defaultFile);
        } else {
            try {
                fc.setSelectedFile(new File(System.getProperty("user.dir")));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        int option = fc.showOpenDialog(this);
        if (option != 0) {
            return null;
        }
        return fc.getSelectedFiles();
    }

    private File saveFileDialog(File defaultFile, FileFilter filter) {
        JFileChooser fc = new JFileChooser(){

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                if (file != null && file.exists() && !this.askOverwrite(file)) {
                    return;
                }
                super.approveSelection();
            }

            private boolean askOverwrite(File file) {
                String title = "Overwriting " + file.getPath();
                String message = "File " + file.getName() + " already exists.\n" + "Do you like to replace it?";
                int choice = JOptionPane.showConfirmDialog(this, message, title, 0, 2);
                return choice == 0;
            }
        };
        fc.setMultiSelectionEnabled(false);
        fc.setSelectedFile(defaultFile);
        fc.setFileFilter(filter);
        int option = fc.showSaveDialog(this);
        if (option != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }

    private File selectDirectoryDialog(File defaultFile) {
        JFileChooser fc = new JFileChooser();
        fc.setMultiSelectionEnabled(false);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(1);
        if (defaultFile != null) {
            fc.setSelectedFile(defaultFile);
        } else {
            try {
                fc.setSelectedFile(new File(System.getProperty("user.dir")));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        int option = fc.showOpenDialog(this);
        if (option != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }

    private File[] openBspFileDialog(File bspFile) {
        return this.openFileDialog(bspFile, new FileExtensionFilter("Source engine map file", "bsp"));
    }

    private File saveVmfFileDialog(File vmfFile) {
        return this.saveFileDialog(vmfFile, new FileExtensionFilter("Hammer map file", "vmf"));
    }

    private void startBspSource() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set<BspFileEntry> files = BspSourceFrame.this.config.getFileSet();
                files.clear();
                Enumeration bspListFiles = BspSourceFrame.this.listFilesModel.elements();
                while (bspListFiles.hasMoreElements()) {
                    files.add((BspFileEntry)bspListFiles.nextElement());
                }
                BspSourceFrame.this.logFrame.clear();
                if (!BspSourceFrame.this.logFrame.isVisible()) {
                    BspSourceFrame.this.logFrame.setVisible(true);
                }
                BspSourceFrame.this.logFrame.requestFocus();
                BspSourceFrame.this.logFrame.setLogging(true);
                BspSourceFrame.this.setButtonsEnabled(false);
                try {
                    BspSource bspsource = new BspSource(BspSourceFrame.this.config);
                    bspsource.run();
                }
                catch (Throwable t) {
                    L.log(Level.SEVERE, "Fatal BSPSource error", t);
                }
                finally {
                    BspSourceFrame.this.setButtonsEnabled(true);
                    BspSourceFrame.this.logFrame.setLogging(false);
                }
            }
        }.start();
    }

    private void initComponentsCustom() {
        this.setTitle("BSPSource 1.3.21");
        this.logFrame = new BspSourceLogFrame();
        try {
            URL iconUrl = this.getClass().getResource("resources/icon.png");
            Image icon = Toolkit.getDefaultToolkit().createImage(iconUrl);
            this.setIconImage(icon);
            this.logFrame.setIconImage(icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.buttonGroupBrushMode = new ButtonGroup();
        this.tabbedPaneOptions = new JTabbedPane();
        this.panelFiles = new JPanel();
        this.scrollFiles = new JScrollPane();
        this.listFiles = new JList();
        this.buttonAdd = new JButton();
        this.buttonRemove = new JButton();
        this.buttonRemoveAll = new JButton();
        this.labelDnDTip = new JLabel();
        this.panelWorldBrushes = new JPanel();
        this.checkBoxDisp = new JCheckBox();
        this.checkBoxEnableWorldBrushes = new JCheckBox();
        this.panelBrushMode = new JPanel();
        this.radioButtonBrushesPlanes = new JRadioButton();
        this.radioButtonOrigFaces = new JRadioButton();
        this.radioButtonSplitFaces = new JRadioButton();
        this.radioButtonOrigSplitFaces = new JRadioButton();
        this.panelEntities = new JPanel();
        this.panelPointEnts = new JPanel();
        this.checkBoxPropStatic = new JCheckBox();
        this.checkBoxCubemap = new JCheckBox();
        this.checkBoxOverlay = new JCheckBox();
        this.panelBrushEnts = new JPanel();
        this.checkBoxDetail = new JCheckBox();
        this.checkBoxAreaportal = new JCheckBox();
        this.checkBoxOccluder = new JCheckBox();
        this.checkBoxFixRotation = new JCheckBox();
        this.checkBoxLadder = new JCheckBox();
        this.checkBoxEnableEntities = new JCheckBox();
        this.panelTextures = new JPanel();
        this.labelFaceTex = new JLabel();
        this.labelBackfaceTex = new JLabel();
        this.comboBoxFaceTex = new JComboBox();
        this.comboBoxBackfaceTex = new JComboBox();
        this.checkBoxFixCubemapTex = new JCheckBox();
        this.checkBoxFixToolTex = new JCheckBox();
        this.panelOther = new JPanel();
        this.checkBoxDebugMode = new JCheckBox();
        this.checkBoxLoadLumpFile = new JCheckBox();
        this.comboBoxMapFormat = new JComboBox();
        this.labelMapFormat = new JLabel();
        this.checkBoxVisgroups = new JCheckBox();
        this.checkBoxCameras = new JCheckBox();
        this.checkBoxExtractEmbedded = new JCheckBox();
        this.labelSourceFormat = new JLabel();
        this.comboBoxSourceFormat = new JComboBox();
        this.buttonDecompile = new JButton();
        this.buttonDefaults = new JButton();
        this.setDefaultCloseOperation(3);
        this.setLocationByPlatform(true);
        this.setResizable(false);
        this.listFiles.setModel(this.getFilesModel());
        this.scrollFiles.setViewportView(this.listFiles);
        this.buttonAdd.setText("Add");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.buttonAddActionPerformed(evt);
            }
        });
        this.buttonRemove.setText("Remove");
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.buttonRemoveActionPerformed(evt);
            }
        });
        this.buttonRemoveAll.setText("Remove all");
        this.buttonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.buttonRemoveAllActionPerformed(evt);
            }
        });
        this.labelDnDTip.setText("Tip: drag and drop files/folders on the box above");
        GroupLayout panelFilesLayout = new GroupLayout(this.panelFiles);
        this.panelFiles.setLayout(panelFilesLayout);
        panelFilesLayout.setHorizontalGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFilesLayout.createSequentialGroup().addContainerGap().addGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelFilesLayout.createSequentialGroup().addComponent(this.scrollFiles, -1, 205, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonRemove, -1, -1, Short.MAX_VALUE).addComponent(this.buttonAdd, -1, -1, Short.MAX_VALUE).addComponent(this.buttonRemoveAll, -1, -1, Short.MAX_VALUE))).addComponent(this.labelDnDTip)).addContainerGap()));
        panelFilesLayout.setVerticalGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFilesLayout.createSequentialGroup().addContainerGap().addGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollFiles, -1, 158, Short.MAX_VALUE).addGroup(panelFilesLayout.createSequentialGroup().addComponent(this.buttonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveAll))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelDnDTip).addContainerGap()));
        this.tabbedPaneOptions.addTab("Files", this.panelFiles);
        this.checkBoxDisp.setText("Write displacements");
        this.checkBoxDisp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxDispActionPerformed(evt);
            }
        });
        this.checkBoxEnableWorldBrushes.setText("Enable");
        this.checkBoxEnableWorldBrushes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxEnableWorldBrushesActionPerformed(evt);
            }
        });
        this.panelBrushMode.setBorder(BorderFactory.createTitledBorder("Mode"));
        this.buttonGroupBrushMode.add(this.radioButtonBrushesPlanes);
        this.radioButtonBrushesPlanes.setText("Brushes and planes");
        this.radioButtonBrushesPlanes.setToolTipText("<html>Create brushes that closely resemble those<br>\nbrushes from which the map was originally created from.</html>");
        this.radioButtonBrushesPlanes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.radioButtonBrushesPlanesActionPerformed(evt);
            }
        });
        this.buttonGroupBrushMode.add(this.radioButtonOrigFaces);
        this.radioButtonOrigFaces.setText("Original faces only");
        this.radioButtonOrigFaces.setToolTipText("<html>Create flat brushes from the culled<br>\nbrush sides of the original brushes.<br>\n<b>Note:</b> some sides may be missing.</html>");
        this.radioButtonOrigFaces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.radioButtonOrigFacesActionPerformed(evt);
            }
        });
        this.buttonGroupBrushMode.add(this.radioButtonSplitFaces);
        this.radioButtonSplitFaces.setText("Split faces only");
        this.radioButtonSplitFaces.setToolTipText("<html>Create flat brushes from the split faces<br>\nthe engine is using for rendering.\n</html>");
        this.radioButtonSplitFaces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.radioButtonSplitFacesActionPerformed(evt);
            }
        });
        this.buttonGroupBrushMode.add(this.radioButtonOrigSplitFaces);
        this.radioButtonOrigSplitFaces.setText("Original/split faces");
        this.radioButtonOrigSplitFaces.setToolTipText("<html>Create flat brushes from the culled<br>\nbrush sides of the original brushes.<br>\nWhen a side doesn't exist, the split face<br>\nis created instead.\n</html>");
        this.radioButtonOrigSplitFaces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.radioButtonOrigSplitFacesActionPerformed(evt);
            }
        });
        GroupLayout panelBrushModeLayout = new GroupLayout(this.panelBrushMode);
        this.panelBrushMode.setLayout(panelBrushModeLayout);
        panelBrushModeLayout.setHorizontalGroup(panelBrushModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelBrushModeLayout.createSequentialGroup().addContainerGap().addGroup(panelBrushModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioButtonBrushesPlanes).addComponent(this.radioButtonOrigFaces).addComponent(this.radioButtonOrigSplitFaces).addComponent(this.radioButtonSplitFaces)).addContainerGap(-1, Short.MAX_VALUE)));
        panelBrushModeLayout.setVerticalGroup(panelBrushModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelBrushModeLayout.createSequentialGroup().addComponent(this.radioButtonBrushesPlanes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonOrigFaces).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonOrigSplitFaces).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonSplitFaces).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout panelWorldBrushesLayout = new GroupLayout(this.panelWorldBrushes);
        this.panelWorldBrushes.setLayout(panelWorldBrushesLayout);
        panelWorldBrushesLayout.setHorizontalGroup(panelWorldBrushesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelWorldBrushesLayout.createSequentialGroup().addContainerGap().addGroup(panelWorldBrushesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelWorldBrushesLayout.createSequentialGroup().addComponent(this.panelBrushMode, -2, -1, -2).addGap(18, 18, 18).addComponent(this.checkBoxDisp)).addComponent(this.checkBoxEnableWorldBrushes)).addContainerGap(24, Short.MAX_VALUE)));
        panelWorldBrushesLayout.setVerticalGroup(panelWorldBrushesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelWorldBrushesLayout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxEnableWorldBrushes).addGap(7, 7, 7).addGroup(panelWorldBrushesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxDisp).addComponent(this.panelBrushMode, -2, -1, -2)).addContainerGap(41, Short.MAX_VALUE)));
        this.tabbedPaneOptions.addTab("World", this.panelWorldBrushes);
        this.panelPointEnts.setBorder(BorderFactory.createTitledBorder("Point entities"));
        this.checkBoxPropStatic.setText("prop_static");
        this.checkBoxPropStatic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxPropStaticActionPerformed(evt);
            }
        });
        this.checkBoxCubemap.setText("info_cubemap");
        this.checkBoxCubemap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxCubemapActionPerformed(evt);
            }
        });
        this.checkBoxOverlay.setText("info_overlay");
        this.checkBoxOverlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxOverlayActionPerformed(evt);
            }
        });
        GroupLayout panelPointEntsLayout = new GroupLayout(this.panelPointEnts);
        this.panelPointEnts.setLayout(panelPointEntsLayout);
        panelPointEntsLayout.setHorizontalGroup(panelPointEntsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPointEntsLayout.createSequentialGroup().addContainerGap().addGroup(panelPointEntsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxPropStatic).addComponent(this.checkBoxCubemap).addComponent(this.checkBoxOverlay)).addContainerGap(-1, Short.MAX_VALUE)));
        panelPointEntsLayout.setVerticalGroup(panelPointEntsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPointEntsLayout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxPropStatic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxCubemap).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxOverlay).addContainerGap(-1, Short.MAX_VALUE)));
        this.panelBrushEnts.setBorder(BorderFactory.createTitledBorder("Brush entities"));
        this.checkBoxDetail.setText("func_detail");
        this.checkBoxDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxDetailActionPerformed(evt);
            }
        });
        this.checkBoxAreaportal.setText("func_areaportal/_window");
        this.checkBoxAreaportal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxAreaportalActionPerformed(evt);
            }
        });
        this.checkBoxOccluder.setText("func_occluder");
        this.checkBoxOccluder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxOccluderActionPerformed(evt);
            }
        });
        this.checkBoxFixRotation.setText("Fix rotation of instances");
        this.checkBoxFixRotation.setToolTipText("<html>\nFixes rotation of brush entities that were compiled from rotated instances.<br>\nThe wrong rotation of these brushes is visible in Hammer only and <br>\nwon't affect re-compilation.\n</html>");
        this.checkBoxFixRotation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxFixRotationActionPerformed(evt);
            }
        });
        this.checkBoxLadder.setText("func_ladder");
        this.checkBoxLadder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxLadderActionPerformed(evt);
            }
        });
        GroupLayout panelBrushEntsLayout = new GroupLayout(this.panelBrushEnts);
        this.panelBrushEnts.setLayout(panelBrushEntsLayout);
        panelBrushEntsLayout.setHorizontalGroup(panelBrushEntsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelBrushEntsLayout.createSequentialGroup().addContainerGap().addGroup(panelBrushEntsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxDetail).addComponent(this.checkBoxAreaportal).addComponent(this.checkBoxOccluder).addComponent(this.checkBoxFixRotation).addComponent(this.checkBoxLadder)).addContainerGap(-1, Short.MAX_VALUE)));
        panelBrushEntsLayout.setVerticalGroup(panelBrushEntsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelBrushEntsLayout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxDetail).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxAreaportal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxOccluder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxLadder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxFixRotation).addContainerGap(-1, Short.MAX_VALUE)));
        this.checkBoxEnableEntities.setText("Enable");
        this.checkBoxEnableEntities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxEnableEntitiesActionPerformed(evt);
            }
        });
        GroupLayout panelEntitiesLayout = new GroupLayout(this.panelEntities);
        this.panelEntities.setLayout(panelEntitiesLayout);
        panelEntitiesLayout.setHorizontalGroup(panelEntitiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelEntitiesLayout.createSequentialGroup().addContainerGap().addGroup(panelEntitiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxEnableEntities).addGroup(panelEntitiesLayout.createSequentialGroup().addComponent(this.panelPointEnts, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelBrushEnts, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        panelEntitiesLayout.setVerticalGroup(panelEntitiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelEntitiesLayout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxEnableEntities).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelEntitiesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.panelBrushEnts, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.panelPointEnts, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.tabbedPaneOptions.addTab("Entities", this.panelEntities);
        this.labelFaceTex.setText("Face texture");
        this.labelBackfaceTex.setText("Back-face texture");
        this.comboBoxFaceTex.setModel(this.getFaceTextureModel());
        this.comboBoxFaceTex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.comboBoxFaceTexActionPerformed(evt);
            }
        });
        this.comboBoxBackfaceTex.setModel(this.getFaceTextureModel());
        this.comboBoxBackfaceTex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.comboBoxBackfaceTexActionPerformed(evt);
            }
        });
        this.checkBoxFixCubemapTex.setText("Fix cubemap textures");
        this.checkBoxFixCubemapTex.setToolTipText("Fix textures for environment-mapped materials.");
        this.checkBoxFixCubemapTex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxFixCubemapTexActionPerformed(evt);
            }
        });
        this.checkBoxFixToolTex.setText("Fix tool textures");
        this.checkBoxFixToolTex.setToolTipText("Fix tool textures such as toolsnodraw or toolsblocklight.");
        this.checkBoxFixToolTex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxFixToolTexActionPerformed(evt);
            }
        });
        GroupLayout panelTexturesLayout = new GroupLayout(this.panelTextures);
        this.panelTextures.setLayout(panelTexturesLayout);
        panelTexturesLayout.setHorizontalGroup(panelTexturesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTexturesLayout.createSequentialGroup().addContainerGap().addGroup(panelTexturesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxFixToolTex).addComponent(this.checkBoxFixCubemapTex).addGroup(panelTexturesLayout.createSequentialGroup().addGroup(panelTexturesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelBackfaceTex).addComponent(this.labelFaceTex)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelTexturesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.comboBoxFaceTex, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.comboBoxBackfaceTex, GroupLayout.Alignment.LEADING, -2, -1, -2)))).addContainerGap(177, Short.MAX_VALUE)));
        panelTexturesLayout.setVerticalGroup(panelTexturesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTexturesLayout.createSequentialGroup().addContainerGap().addGroup(panelTexturesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboBoxFaceTex, -2, -1, -2).addComponent(this.labelFaceTex)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelTexturesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelBackfaceTex).addComponent(this.comboBoxBackfaceTex, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkBoxFixCubemapTex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxFixToolTex).addContainerGap(90, Short.MAX_VALUE)));
        this.tabbedPaneOptions.addTab("Textures", this.panelTextures);
        this.checkBoxDebugMode.setText("Debug mode");
        this.checkBoxDebugMode.setToolTipText("<html>\nThe debug mode produces <i>very</i> verbose output<br>\ntext and writes additional data into the VMF file.\n</html>");
        this.checkBoxDebugMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxDebugModeActionPerformed(evt);
            }
        });
        this.checkBoxLoadLumpFile.setText("Load lump files");
        this.checkBoxLoadLumpFile.setToolTipText("<html>\nWhen enabled, external lump files  <i>(.lmp)</i> with the same<br>\nname as the BSP file will be processed during decompilation.\n</html>");
        this.checkBoxLoadLumpFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxLoadLumpFileActionPerformed(evt);
            }
        });
        this.comboBoxMapFormat.setModel(this.getAppIDModel());
        this.comboBoxMapFormat.setToolTipText("<html>\n<p>Overrides the internal game detection for maps.</p>\n<p>Select <i>\"Unknown\"</i> for automatic detection.</p>\n<br>\n<b>Warning:</b> Change only if the game isn't detected<br>\ncorrectly, wrong values can cause program errors!\n</html>");
        this.comboBoxMapFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.comboBoxMapFormatActionPerformed(evt);
            }
        });
        this.labelMapFormat.setText("BSP format");
        this.checkBoxVisgroups.setText("Create Hammer visgroups");
        this.checkBoxVisgroups.setToolTipText("<html>Automatically group instanced entities to visgroups.\n<p><b>Note:</b> World brushes created from instances can't<br>\nbe grouped because of missing information.</p>\n</html>");
        this.checkBoxVisgroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxVisgroupsActionPerformed(evt);
            }
        });
        this.checkBoxCameras.setText("Create Hammer cameras");
        this.checkBoxCameras.setToolTipText("<html>Create Hammer viewport cameras above <br>\neach player spawn to ease navigation.</html>");
        this.checkBoxCameras.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxCamerasActionPerformed(evt);
            }
        });
        this.checkBoxExtractEmbedded.setText("Extract embedded files");
        this.checkBoxExtractEmbedded.setToolTipText("<html>\nExtract all resource files that are embedded into the BSP file.\n</html>");
        this.checkBoxExtractEmbedded.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.checkBoxExtractEmbeddedActionPerformed(evt);
            }
        });
        this.labelSourceFormat.setText("VMF format");
        this.comboBoxSourceFormat.setModel(this.getSourceFormatModel());
        this.comboBoxSourceFormat.setToolTipText("<html>\n<p>Sets the VMF source format.</p>\n<p>On default, newer maps are decompiled to a format<br/>\nthat is incompatible with older Hammer versions. <br/>\nSelect <i>\"Source 2004-2009\"</i> if you want to make sure that<br/>\nthe decompiled map is loadable in old Hammer versions.\n</html>");
        this.comboBoxSourceFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.comboBoxSourceFormatActionPerformed(evt);
            }
        });
        GroupLayout panelOtherLayout = new GroupLayout(this.panelOther);
        this.panelOther.setLayout(panelOtherLayout);
        panelOtherLayout.setHorizontalGroup(panelOtherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelOtherLayout.createSequentialGroup().addContainerGap().addGroup(panelOtherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxExtractEmbedded).addGroup(panelOtherLayout.createSequentialGroup().addGroup(panelOtherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxDebugMode).addComponent(this.checkBoxLoadLumpFile)).addGap(18, 18, 18).addGroup(panelOtherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxCameras).addComponent(this.checkBoxVisgroups))).addGroup(panelOtherLayout.createSequentialGroup().addGroup(panelOtherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelSourceFormat).addComponent(this.labelMapFormat)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelOtherLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.comboBoxMapFormat, 0, 190, Short.MAX_VALUE).addComponent(this.comboBoxSourceFormat, 0, -1, Short.MAX_VALUE)))).addContainerGap(44, Short.MAX_VALUE)));
        panelOtherLayout.setVerticalGroup(panelOtherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelOtherLayout.createSequentialGroup().addContainerGap().addGroup(panelOtherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelOtherLayout.createSequentialGroup().addComponent(this.checkBoxDebugMode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxLoadLumpFile)).addGroup(panelOtherLayout.createSequentialGroup().addComponent(this.checkBoxVisgroups).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxCameras))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxExtractEmbedded).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelOtherLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelMapFormat).addComponent(this.comboBoxMapFormat, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelOtherLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSourceFormat).addComponent(this.comboBoxSourceFormat, -2, -1, -2)).addContainerGap(76, Short.MAX_VALUE)));
        this.tabbedPaneOptions.addTab("Other", this.panelOther);
        this.buttonDecompile.setFont(new Font("Tahoma", 1, 11));
        this.buttonDecompile.setText("Decompile");
        this.buttonDecompile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.buttonDecompileActionPerformed(evt);
            }
        });
        this.buttonDefaults.setText("Defaults");
        this.buttonDefaults.setToolTipText("Resets all configurations to their defaults.");
        this.buttonDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspSourceFrame.this.buttonDefaultsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPaneOptions, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.buttonDefaults).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonDecompile))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPaneOptions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonDefaults).addComponent(this.buttonDecompile)).addContainerGap()));
        this.pack();
    }

    private void checkBoxLadderActionPerformed(ActionEvent evt) {
        this.config.writeLadders = this.checkBoxLadder.isSelected();
    }

    private void checkBoxEnableEntitiesActionPerformed(ActionEvent evt) {
        this.config.setWriteEntities(this.checkBoxEnableEntities.isSelected());
        this.setPanelEnabled(this.panelEntities, this.checkBoxEnableEntities);
    }

    private void checkBoxPropStaticActionPerformed(ActionEvent evt) {
        this.config.writeStaticProps = this.checkBoxPropStatic.isSelected();
    }

    private void checkBoxAreaportalActionPerformed(ActionEvent evt) {
        this.config.writeAreaportals = this.checkBoxAreaportal.isSelected();
    }

    private void checkBoxOccluderActionPerformed(ActionEvent evt) {
        this.config.writeOccluders = this.checkBoxOccluder.isSelected();
    }

    private void checkBoxDetailActionPerformed(ActionEvent evt) {
        this.config.writeDetails = this.checkBoxDetail.isSelected();
    }

    private void checkBoxOverlayActionPerformed(ActionEvent evt) {
        this.config.writeOverlays = this.checkBoxOverlay.isSelected();
    }

    private void checkBoxCubemapActionPerformed(ActionEvent evt) {
        this.config.writeCubemaps = this.checkBoxCubemap.isSelected();
    }

    private void checkBoxFixRotationActionPerformed(ActionEvent evt) {
        this.config.fixEntityRot = this.checkBoxFixRotation.isSelected();
    }

    private void buttonDecompileActionPerformed(ActionEvent evt) {
        if (this.listFilesModel.isEmpty()) {
            return;
        }
        if (this.listFilesModel.size() == 1) {
            BspFileEntry entry = this.listFilesModel.firstElement();
            File vmfFile = this.saveVmfFileDialog(entry.getVmfFile());
            if (vmfFile == null) {
                return;
            }
            entry.setVmfFile(vmfFile);
            entry.setPakDir(new File(vmfFile.getAbsoluteFile().getParentFile(), entry.getPakDir().getName()));
        } else {
            File dstDir = this.selectDirectoryDialog(null);
            if (dstDir == null) {
                return;
            }
            Enumeration<BspFileEntry> entries = this.listFilesModel.elements();
            while (entries.hasMoreElements()) {
                BspFileEntry entry = entries.nextElement();
                entry.setVmfFile(new File(dstDir, entry.getVmfFile().getName()));
                entry.setPakDir(new File(dstDir, entry.getPakDir().getName()));
            }
        }
        this.startBspSource();
    }

    private void buttonDefaultsActionPerformed(ActionEvent evt) {
        this.reset();
    }

    private void checkBoxDispActionPerformed(ActionEvent evt) {
        this.config.writeDisp = this.checkBoxDisp.isSelected();
    }

    private void comboBoxFaceTexActionPerformed(ActionEvent evt) {
        EnumToolTexture tex = (EnumToolTexture)((Object)this.comboBoxFaceTex.getSelectedItem());
        this.config.faceTexture = tex.texPath;
    }

    private void comboBoxBackfaceTexActionPerformed(ActionEvent evt) {
        EnumToolTexture tex = (EnumToolTexture)((Object)this.comboBoxBackfaceTex.getSelectedItem());
        this.config.backfaceTexture = tex.texPath;
    }

    private void checkBoxFixCubemapTexActionPerformed(ActionEvent evt) {
        this.config.fixCubemapTextures = this.checkBoxFixCubemapTex.isSelected();
    }

    private void checkBoxDebugModeActionPerformed(ActionEvent evt) {
        this.config.setDebug(this.checkBoxDebugMode.isSelected());
    }

    private void checkBoxLoadLumpFileActionPerformed(ActionEvent evt) {
        this.config.loadLumpFiles = this.checkBoxLoadLumpFile.isSelected();
    }

    private void buttonRemoveAllActionPerformed(ActionEvent evt) {
        this.listFilesModel.clear();
        this.buttonDecompile.setEnabled(false);
    }

    private void buttonRemoveActionPerformed(ActionEvent evt) {
        int[] selected = this.listFiles.getSelectedIndices();
        this.listFiles.clearSelection();
        for (int index : selected) {
            this.listFilesModel.remove(index);
        }
        this.buttonDecompile.setEnabled(!this.listFilesModel.isEmpty());
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        File[] bspFiles;
        File bspFile = null;
        if (this.listFilesModel.size() == 1) {
            bspFile = this.listFilesModel.firstElement().getBspFile();
        }
        if ((bspFiles = this.openBspFileDialog(bspFile)) == null) {
            return;
        }
        for (File file : bspFiles) {
            this.listFilesModel.addElement(new BspFileEntry(file));
        }
        this.buttonDecompile.setEnabled(!this.listFilesModel.isEmpty());
    }

    private void comboBoxMapFormatActionPerformed(ActionEvent evt) {
        this.config.defaultApp = (SourceApp)this.comboBoxMapFormat.getSelectedItem();
    }

    private void checkBoxEnableWorldBrushesActionPerformed(ActionEvent evt) {
        this.config.writeWorldBrushes = this.checkBoxEnableWorldBrushes.isSelected();
        this.setPanelEnabled(this.panelWorldBrushes, this.checkBoxEnableWorldBrushes);
    }

    private void checkBoxVisgroupsActionPerformed(ActionEvent evt) {
        this.config.writeVisgroups = this.checkBoxVisgroups.isSelected();
    }

    private void checkBoxCamerasActionPerformed(ActionEvent evt) {
        this.config.writeCameras = this.checkBoxCameras.isSelected();
    }

    private void radioButtonBrushesPlanesActionPerformed(ActionEvent evt) {
        this.config.brushMode = BrushMode.BRUSHPLANES;
    }

    private void radioButtonOrigFacesActionPerformed(ActionEvent evt) {
        this.config.brushMode = BrushMode.ORIGFACE;
    }

    private void radioButtonOrigSplitFacesActionPerformed(ActionEvent evt) {
        this.config.brushMode = BrushMode.ORIGFACE_PLUS;
    }

    private void radioButtonSplitFacesActionPerformed(ActionEvent evt) {
        this.config.brushMode = BrushMode.SPLITFACE;
    }

    private void checkBoxFixToolTexActionPerformed(ActionEvent evt) {
        this.config.fixToolTextures = this.checkBoxFixToolTex.isSelected();
    }

    private void checkBoxExtractEmbeddedActionPerformed(ActionEvent evt) {
        this.config.unpackEmbedded = this.checkBoxExtractEmbedded.isSelected();
    }

    private void comboBoxSourceFormatActionPerformed(ActionEvent evt) {
        this.config.sourceFormat = (SourceFormat)((Object)this.comboBoxSourceFormat.getSelectedItem());
    }
}

