/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc;

import info.ata4.bsplib.app.SourceApp;
import info.ata4.bspsrc.BspFileEntry;
import info.ata4.bspsrc.modules.geom.BrushMode;
import info.ata4.bspsrc.util.SourceFormat;
import info.ata4.log.LogUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BspSourceConfig
implements Serializable {
    private static final Logger L = LogUtils.getLogger();
    public SourceApp defaultApp = SourceApp.UNKNOWN;
    public BrushMode brushMode = BrushMode.BRUSHPLANES;
    public SourceFormat sourceFormat = SourceFormat.AUTO;
    public String backfaceTexture = "";
    public String faceTexture = "";
    public boolean fixCubemapTextures = true;
    public boolean fixEntityRot = true;
    public boolean fixToolTextures = true;
    public boolean loadLumpFiles = true;
    public boolean nullOutput = false;
    public boolean skipProt = false;
    public boolean unpackEmbedded = false;
    public float backfaceDepth = 1.0f;
    public int maxCubemapSides = 8;
    public int maxOverlaySides = 64;
    public boolean detailMerge = true;
    public float detailMergeThresh = 1.0f;
    public boolean writeAreaportals = true;
    public boolean writeBrushEntities = true;
    public boolean writeCameras = true;
    public boolean writeCubemaps = true;
    public boolean writeDetails = true;
    public boolean writeDisp = true;
    public boolean writeOccluders = true;
    public boolean writeOverlays = true;
    public boolean writePointEntities = true;
    public boolean writeStaticProps = true;
    public boolean writeVisgroups = true;
    public boolean writeWorldBrushes = true;
    public boolean writeLadders = true;
    private boolean debug = false;
    private Set<BspFileEntry> files = new HashSet<BspFileEntry>();

    private void updateLogger(boolean debug) {
        LogUtils.configure(debug ? Level.ALL : Level.INFO);
        if (debug) {
            L.fine("Debug mode on, verbosity set to maximum");
        }
    }

    public void dumpToLog() {
        this.dumpToLog(L);
    }

    public void dumpToLog(Logger logger) {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                logger.log(Level.CONFIG, "{0} = {1}", new Object[]{field.getName(), field.get(this)});
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public Set<BspFileEntry> getFileSet() {
        return this.files;
    }

    public boolean isWriteEntities() {
        return this.writeBrushEntities || this.writePointEntities;
    }

    public void setWriteEntities(boolean writeEntities) {
        this.writeBrushEntities = this.writePointEntities = writeEntities;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.updateLogger(debug);
        this.debug = debug;
    }
}

