/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.vector;

import info.ata4.bsplib.vector.VectorXf;
import info.ata4.io.DataReader;
import info.ata4.io.DataWriter;
import java.io.IOException;

public final class Vector4f
extends VectorXf {
    public static final Vector4f NULL = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f MAX_VALUE = new Vector4f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
    public static final Vector4f MIN_VALUE = MAX_VALUE.scalar(-1.0f);
    public final float x;
    public final float y;
    public final float z;
    public final float w;

    public static Vector4f read(DataReader in) throws IOException {
        float x = in.readFloat();
        float y = in.readFloat();
        float z = in.readFloat();
        float w = in.readFloat();
        return new Vector4f(x, y, z, w);
    }

    public static void write(DataWriter out, Vector4f vec) throws IOException {
        out.writeFloat(vec.x);
        out.writeFloat(vec.y);
        out.writeFloat(vec.z);
        out.writeFloat(vec.w);
    }

    public Vector4f(Vector4f v) {
        this(v.x, v.y, v.z, v.w);
    }

    public Vector4f(float[] v) {
        this(v[0], v[1], v[2], v[3]);
    }

    public Vector4f(float x, float y, float z, float w) {
        super(4);
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Override
    public float get(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        return 0.0f;
    }

    @Override
    public Vector4f set(int index, float value) {
        switch (index) {
            case 0: {
                return new Vector4f(value, this.y, this.z, this.w);
            }
            case 1: {
                return new Vector4f(this.x, value, this.z, this.w);
            }
            case 2: {
                return new Vector4f(this.x, this.y, value, this.w);
            }
            case 3: {
                return new Vector4f(this.x, this.y, this.z, value);
            }
        }
        return this;
    }

    public float dot(Vector4f that) {
        return this.x * that.x + this.y * that.y + this.z * that.z;
    }

    public Vector4f normalize() {
        float len = this.length();
        float rx = this.x / len;
        float ry = this.y / len;
        float rz = this.z / len;
        float rw = this.w / len;
        return new Vector4f(rx, ry, rz, rw);
    }

    public Vector4f add(Vector4f that) {
        float rx = this.x + that.x;
        float ry = this.y + that.y;
        float rz = this.z + that.z;
        float rw = this.w + that.w;
        return new Vector4f(rx, ry, rz, rw);
    }

    public Vector4f sub(Vector4f that) {
        float rx = this.x - that.x;
        float ry = this.y - that.y;
        float rz = this.z - that.z;
        float rw = this.w - that.w;
        return new Vector4f(rx, ry, rz, rw);
    }

    public Vector4f snap(float value) {
        float rx = (float)Math.round(this.x / value) * value;
        float ry = (float)Math.round(this.y / value) * value;
        float rz = (float)Math.round(this.z / value) * value;
        float rw = (float)Math.round(this.w / value) * value;
        return new Vector4f(rx, ry, rz, rw);
    }

    public float length() {
        return (float)Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0) + Math.pow(this.w, 2.0));
    }

    public Vector4f scalar(float mul) {
        float rx = this.x * mul;
        float ry = this.y * mul;
        float rz = this.z * mul;
        float rw = this.w * mul;
        return new Vector4f(rx, ry, rz, rw);
    }

    public Vector4f scalar(Vector4f that) {
        float rx = this.x * that.x;
        float ry = this.y * that.y;
        float rz = this.z * that.z;
        float rw = this.w * that.w;
        return new Vector4f(rx, ry, rz, rw);
    }

    public Vector4f min(Vector4f that) {
        float rx = Math.min(this.x, that.x);
        float ry = Math.min(this.y, that.y);
        float rz = Math.min(this.z, that.z);
        float rw = Math.min(this.w, that.w);
        return new Vector4f(rx, ry, rz, rw);
    }

    public Vector4f max(Vector4f that) {
        float rx = Math.max(this.x, that.x);
        float ry = Math.max(this.y, that.y);
        float rz = Math.max(this.z, that.z);
        float rw = Math.max(this.w, that.w);
        return new Vector4f(rx, ry, rz, rw);
    }
}

