/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.struct;

import info.ata4.bsplib.struct.DStruct;
import info.ata4.bsplib.vector.Vector3f;
import info.ata4.io.DataReader;
import info.ata4.io.DataWriter;
import java.io.IOException;

public class DDispInfo
implements DStruct {
    public static final int DISP_INFO_FLAG_HAS_MULTIBLEND = 0x40000000;
    public static final int DISP_INFO_FLAG_MAGIC = Integer.MIN_VALUE;
    public Vector3f startPos;
    public int dispVertStart;
    public int dispTriStart;
    public int power;
    public int minTess;
    public float smoothingAngle;
    public int contents;
    public int mapFace;
    public int lightmapAlphaStart;
    public int lightmapSamplePositionStart;
    protected byte[] neighbors = new byte[90];
    public int[] allowedVerts = new int[10];

    public int getPowerSize() {
        return 1 << this.power;
    }

    public int getVertexCount() {
        return (this.getPowerSize() + 1) * (this.getPowerSize() + 1);
    }

    public int getTriangleTagCount() {
        return 2 * this.getPowerSize() * this.getPowerSize();
    }

    @Override
    public int getSize() {
        return 176;
    }

    @Override
    public void read(DataReader in) throws IOException {
        this.startPos = Vector3f.read(in);
        this.dispVertStart = in.readInt();
        this.dispTriStart = in.readInt();
        this.power = in.readInt();
        this.minTess = in.readInt();
        this.smoothingAngle = in.readFloat();
        this.contents = in.readInt();
        this.mapFace = in.readUnsignedShort();
        this.lightmapAlphaStart = in.readInt();
        this.lightmapSamplePositionStart = in.readInt();
        in.readBytes(this.neighbors);
        for (int i = 0; i < this.allowedVerts.length; ++i) {
            this.allowedVerts[i] = in.readInt();
        }
    }

    @Override
    public void write(DataWriter out) throws IOException {
        Vector3f.write(out, this.startPos);
        out.writeInt(this.dispVertStart);
        out.writeInt(this.dispTriStart);
        out.writeInt(this.power);
        out.writeInt(this.minTess);
        out.writeFloat(this.smoothingAngle);
        out.writeInt(this.contents);
        out.writeUnsignedShort(this.mapFace);
        out.writeInt(this.lightmapAlphaStart);
        out.writeInt(this.lightmapSamplePositionStart);
        out.writeBytes(this.neighbors);
        for (int i = 0; i < this.allowedVerts.length; ++i) {
            out.writeInt(this.allowedVerts[i]);
        }
    }

    public boolean hasMultiBlend() {
        return (this.minTess + Integer.MIN_VALUE & 0x40000000) != 0;
    }
}

