/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.io;

import info.ata4.bsplib.entity.Entity;
import info.ata4.bsplib.entity.KeyValue;
import info.ata4.log.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.input.CountingInputStream;

public class EntityInputStream
extends CountingInputStream {
    private static final Logger L = LogUtils.getLogger();
    private boolean allowEsc = false;

    public EntityInputStream(InputStream in) {
        super(in);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entity readEntity() throws IOException {
        boolean section = false;
        boolean string = false;
        boolean esc = false;
        StringBuilder sb = new StringBuilder(512);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        String key = null;
        try {
            int b = 0;
            while (b != -1) {
                block20: {
                    switch (b) {
                        case 34: {
                            if (!section) {
                                throw new ParseException("String in unopened section", this.getCount());
                            }
                            if (esc) {
                                esc = false;
                                break;
                            }
                            if (string) {
                                if (key == null) {
                                    key = sb.toString();
                                } else {
                                    String value = sb.toString();
                                    if (key.isEmpty()) {
                                        L.log(Level.FINE, "Skipped value \"{0}\" with empty key at {1}", new Object[]{value, this.getCount()});
                                    } else {
                                        keyValues.add(new KeyValue(key, value));
                                    }
                                    key = null;
                                }
                                sb.delete(0, sb.length());
                            }
                            string = !string;
                            break block20;
                        }
                        case 123: {
                            if (section && !string) {
                                throw new ParseException("Opened unclosed section", this.getCount());
                            }
                            if (string) break;
                            section = true;
                            break;
                        }
                        case 125: {
                            if (!section && !string) {
                                throw new ParseException("Closed unopened section", this.getCount());
                            }
                            if (string) break;
                            return new Entity(keyValues);
                        }
                        case 92: {
                            if (!this.allowEsc) break;
                            esc = true;
                        }
                    }
                    if (section && string) {
                        sb.append((char)b);
                    }
                }
                b = this.read();
            }
            return null;
        }
        catch (ParseException ex) {
            L.log(Level.WARNING, "{0} at {1}", new Object[]{ex.getMessage(), ex.getErrorOffset()});
            int b = 0;
            while (b != -1 && b != 125) {
                b = this.read();
            }
            return new Entity(keyValues);
        }
    }

    public boolean isAllowEscSeq() {
        return this.allowEsc;
    }

    public void setAllowEscSeq(boolean allowEsc) {
        this.allowEsc = allowEsc;
    }
}

