/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.entity;

import info.ata4.bsplib.entity.KeyValue;
import org.apache.commons.lang3.StringUtils;

public class EntityIO {
    public static final char SEP_CHR_OLD = ',';
    public static final char SEP_CHR_NEW = '\u001b';
    public static final String SEP_STR_OLD = Character.toString(',');
    public static final String SEP_STR_NEW = Character.toString('\u001b');
    private String targetEntity;
    private String input;
    private String param;
    private float delay;
    private int timesToFire;

    public static boolean isEntityIO(KeyValue kv) {
        String value = kv.getValue();
        if (StringUtils.countMatches((CharSequence)value, SEP_STR_NEW) == 4) {
            return true;
        }
        int matches = StringUtils.countMatches((CharSequence)value, SEP_STR_OLD);
        return matches == 4 || matches == 6;
    }

    public EntityIO(String entityIO) {
        String[] elements = StringUtils.split(entityIO, '\u001b');
        if (elements.length < 4) {
            elements = StringUtils.split(entityIO, ',');
        }
        if (elements.length < 4) {
            throw new IllegalArgumentException("Unsupported I/O format");
        }
        this.targetEntity = elements[0];
        this.input = elements[1];
        this.param = elements[2];
        this.delay = Float.parseFloat(elements[3]);
        this.timesToFire = Integer.parseInt(elements[3]);
    }

    public String getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(String targetEntity) {
        this.targetEntity = targetEntity;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public float getDelay() {
        return this.delay;
    }

    public void setDelay(float delay) {
        this.delay = delay;
    }

    public int getTimesToFire() {
        return this.timesToFire;
    }

    public void setTimesToFire(int timesToFire) {
        this.timesToFire = timesToFire;
    }
}

