/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib;

import info.ata4.bsplib.BspFile;
import info.ata4.bsplib.lump.Lump;
import info.ata4.bsplib.lump.LumpType;
import info.ata4.log.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class PakFile {
    private static final Logger L = LogUtils.getLogger();
    private final Lump pakLump;

    public PakFile(BspFile bspFile) {
        this.pakLump = bspFile.getLump(LumpType.LUMP_PAKFILE);
    }

    public ZipArchiveInputStream getArchiveInputStream() {
        return new ZipArchiveInputStream(this.pakLump.getInputStream(), "Cp437", false);
    }

    public void unpack(Path dest) throws IOException {
        this.unpack(dest, false);
    }

    public void unpack(Path dest, boolean direct) throws IOException {
        if (direct) {
            L.log(Level.INFO, "Extracting pakfile to {0}", dest);
            try (InputStream is = this.pakLump.getInputStream();){
                Files.copy(is, dest, new CopyOption[0]);
            }
        } else {
            this.unpack(dest, null);
        }
    }

    public void unpack(Path dest, List<String> names) throws IOException {
        Files.createDirectories(dest, new FileAttribute[0]);
        try (ZipArchiveInputStream zis = this.getArchiveInputStream();){
            ZipArchiveEntry ze;
            while ((ze = zis.getNextZipEntry()) != null) {
                String zipName = ze.getName();
                if (names != null && !names.contains(zipName)) continue;
                Path entryFile = dest.resolve(zipName = zipName.replace(':', '_'));
                if (Files.notExists(entryFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(entryFile.getParent(), new FileAttribute[0]);
                }
                if (Files.exists(entryFile, new LinkOption[0])) {
                    L.log(Level.INFO, "Skipped {0}", ze.getName());
                    continue;
                }
                L.log(Level.INFO, "Extracting {0}", ze.getName());
                Files.copy(zis, entryFile, new CopyOption[0]);
            }
        }
    }
}

