/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspinfo.gui.models;

import info.ata4.bsplib.BspFile;
import info.ata4.bsplib.lump.Lump;
import info.ata4.util.gui.ListTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LumpTableModel
extends ListTableModel {
    public LumpTableModel() {
        super(5);
        this.columnNames = Arrays.asList("ID", "Name", "Size", "Size usage", "Version");
        this.columnClasses = new Class[]{Integer.class, String.class, Integer.class, Integer.class, Integer.class};
    }

    public LumpTableModel(BspFile bspFile) {
        this();
        List<Lump> lumps = bspFile.getLumps();
        float lumpSize = 0.0f;
        for (Lump l : lumps) {
            lumpSize += (float)l.getLength();
        }
        for (Lump l : lumps) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(l.getIndex());
            row.add(l.getName());
            row.add(l.getLength());
            row.add(Math.round((float)l.getLength() / lumpSize * 100.0f));
            row.add(l.getVersion());
            this.addRow(row);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

